/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.search.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Column;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.PanelCollapse;
import org.gwtbootstrap3.client.ui.PanelGroup;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.extras.typeahead.client.base.Dataset;
import org.gwtbootstrap3.extras.typeahead.client.base.StringDataset;
import org.gwtbootstrap3.extras.typeahead.client.ui.Typeahead;
import org.kie.workbench.common.screens.search.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.search.client.widgets.SearchResultTable;
import org.kie.workbench.common.screens.search.model.QueryMetadataPageRequest;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.type.ClientTypeRegistry;
import org.uberfire.ext.widgets.common.client.common.DatePicker;

@Dependent
@WorkbenchScreen(identifier="FindForm")
public class FindForm
extends Composite {
    private static FindFormBinder uiBinder = (FindFormBinder)GWT.create(FindFormBinder.class);
    @Inject
    private ClientTypeRegistry clientTypeRegistry;
    @UiField
    SimplePanel errorPanel;
    @UiField
    FormGroup formGroup;
    @UiField
    Form form;
    @UiField
    TextBox sourceTextBox;
    @UiField
    TextBox createdByTextBox;
    @UiField
    TextBox descriptionByTextBox;
    @UiField
    Typeahead formatTypeahead;
    @UiField
    TextBox subjectTextBox;
    @UiField
    TextBox typeTextBox;
    @UiField
    TextBox lastModifiedByTextBox;
    @UiField
    TextBox externalLinkTextBox;
    @UiField
    TextBox checkinCommentTextBox;
    @UiField
    DatePicker createdAfter;
    @UiField
    DatePicker createdBefore;
    @UiField
    DatePicker lastModifiedAfter;
    @UiField
    DatePicker lastModifiedBefore;
    @UiField
    PanelGroup accordion;
    @UiField
    PanelHeader formAccordionHeader;
    @UiField
    PanelCollapse formAccordionCollapse;
    @UiField
    PanelHeader resultAccordionHeader;
    @UiField
    PanelCollapse resultAccordionCollapse;
    @UiField
    Column simplePanel;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.accordion.setId(DOM.createUniqueId());
        this.formAccordionHeader.setDataParent(this.accordion.getId());
        this.formAccordionHeader.setDataTargetWidget((Widget)this.formAccordionCollapse);
        this.resultAccordionHeader.setDataParent(this.accordion.getId());
        this.resultAccordionHeader.setDataTargetWidget((Widget)this.resultAccordionCollapse);
        this.createdAfter.setFormat(ApplicationPreferences.getDroolsDateFormat());
        this.createdBefore.setFormat(ApplicationPreferences.getDroolsDateFormat());
        this.lastModifiedAfter.setFormat(ApplicationPreferences.getDroolsDateFormat());
        this.lastModifiedBefore.setFormat(ApplicationPreferences.getDroolsDateFormat());
        this.formGroup.setStyleName(null);
        this.formatTypeahead.setDatasets((Dataset)new StringDataset((Collection)new ArrayList<String>(){
            {
                for (ClientResourceType resourceType : FindForm.this.clientTypeRegistry.getRegisteredTypes()) {
                    this.add(resourceType.getShortName());
                }
            }
        }));
    }

    @UiHandler(value={"clear"})
    public void onClearClick(ClickEvent e) {
        this.form.reset();
    }

    @UiHandler(value={"search"})
    public void onSearchClick(ClickEvent e) {
        this.errorPanel.clear();
        this.formGroup.setValidationState(ValidationState.NONE);
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (!this.sourceTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.source[0]", this.sourceTextBox.getText().trim());
        }
        if (!this.createdByTextBox.getText().trim().isEmpty()) {
            metadata.put("createdBy", this.createdByTextBox.getText().trim());
        }
        if (!this.descriptionByTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.description[0]", this.descriptionByTextBox.getText().trim());
        }
        if (!this.formatTypeahead.getText().trim().isEmpty()) {
            String pattern = this.clientTypeRegistry.resolveWildcardPattern(this.formatTypeahead.getText().trim());
            metadata.put("filename", pattern);
        }
        if (!this.subjectTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.subject[0]", this.subjectTextBox.getText().trim());
        }
        if (!this.typeTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.type[0]", this.typeTextBox.getText().trim());
        }
        if (!this.lastModifiedByTextBox.getText().trim().isEmpty()) {
            metadata.put("lastModifiedBy", this.lastModifiedByTextBox.getText().trim());
        }
        if (!this.externalLinkTextBox.getText().trim().isEmpty()) {
            metadata.put("dcore.relation[0]", this.externalLinkTextBox.getText().trim());
        }
        if (!this.checkinCommentTextBox.getText().trim().isEmpty()) {
            metadata.put("checkinComment", this.checkinCommentTextBox.getText().trim());
        }
        boolean hasSomeDateValue = false;
        if (this.createdAfter.getValue() != null) {
            hasSomeDateValue = true;
        }
        if (this.createdBefore.getValue() != null) {
            hasSomeDateValue = true;
        }
        if (this.lastModifiedAfter.getValue() != null) {
            hasSomeDateValue = true;
        }
        if (this.lastModifiedBefore.getValue() != null) {
            hasSomeDateValue = true;
        }
        if (metadata.size() == 0 && !hasSomeDateValue) {
            this.formGroup.setValidationState(ValidationState.ERROR);
            Alert alert = new Alert(Constants.INSTANCE.AtLeastOneFieldMustBeSet(), AlertType.DANGER);
            alert.setVisible(true);
            alert.setDismissable(true);
            this.errorPanel.add((Widget)alert);
            return;
        }
        SearchResultTable queryTable = new SearchResultTable(new QueryMetadataPageRequest(metadata, this.createdAfter.getValue(), this.createdBefore.getValue(), this.lastModifiedAfter.getValue(), this.lastModifiedBefore.getValue(), 0, null));
        this.simplePanel.clear();
        this.simplePanel.add((Widget)queryTable);
        this.formAccordionCollapse.setIn(false);
        this.resultAccordionCollapse.setIn(true);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.AssetSearch();
    }

    static interface FindFormBinder
    extends UiBinder<Widget, FindForm> {
    }
}

