/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.search.client;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.screens.search.client.resources.i18n.Constants;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="FullTextSearchForm")
public class FullTextSearchFormPresenter {
    @Inject
    private View view;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    private PlaceRequest placeRequest;
    private String title = null;
    private String term = null;

    @PostConstruct
    public void init() {
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
        this.term = placeRequest.getParameter("term", null);
        this.view.setSearchTerm(this.term);
        this.title = Constants.INSTANCE.SearchResultTitle() + " [ " + this.term + " ]";
    }

    @WorkbenchPartView
    public UberView<FullTextSearchFormPresenter> getWidget() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String term) {
        if (!this.term.equals(term)) {
            this.term = term;
            this.title = Constants.INSTANCE.SearchResultTitle() + " [ " + term + " ]";
            this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, this.title));
        }
    }

    public static interface View
    extends UberView<FullTextSearchFormPresenter> {
        public void setSearchTerm(String var1);
    }
}

