/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.search.client.menu;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.widgets.client.search.ClearSearchEvent;
import org.kie.workbench.common.widgets.client.search.ContextualSearch;
import org.kie.workbench.common.widgets.client.search.SearchBehavior;
import org.kie.workbench.common.widgets.client.search.SetSearchTextEvent;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class SearchMenuPresenter
implements IsWidget {
    @Inject
    private View view;
    @Inject
    private ContextualSearch contextualSearch;
    @Inject
    private PlaceManager placeManager;

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.contextualSearch.setDefaultSearchBehavior(new SearchBehavior(){

            public void execute(String term) {
                SearchMenuPresenter.this.placeManager.goTo(new DefaultPlaceRequest("FullTextSearchForm").addParameter("term", term));
            }
        });
    }

    public View getView() {
        return this.view;
    }

    public void onClearSearchBox(@Observes ClearSearchEvent clearSearch) {
        this.view.setText("");
    }

    public void onSetSearchText(@Observes SetSearchTextEvent setSearchText) {
        this.view.setText(setSearchText.getSearchText());
    }

    public void search(String searchText) {
        this.contextualSearch.getSearchBehavior().execute(searchText);
    }

    public static interface View
    extends IsWidget,
    UberView<SearchMenuPresenter> {
        public void setText(String var1);
    }
}

