/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.search.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.screens.search.client.FullTextSearchFormPresenter;
import org.kie.workbench.common.screens.search.client.widgets.SearchResultTable;
import org.kie.workbench.common.screens.search.model.SearchTermPageRequest;

@Dependent
public class FullTextSearchFormView
extends Composite
implements FullTextSearchFormPresenter.View {
    private static FullTextSearchFormBinder uiBinder = (FullTextSearchFormBinder)GWT.create(FullTextSearchFormBinder.class);
    @UiField
    SimplePanel resultPanel;
    @UiField
    TextBox termTextBox;
    private FullTextSearchFormPresenter presenter;
    private String text = null;

    public void init(FullTextSearchFormPresenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @Override
    public void setSearchTerm(String term) {
        this.termTextBox.setText(term);
        this.search();
    }

    @UiHandler(value={"search"})
    public void onSearchClick(ClickEvent e) {
        this.search();
    }

    private void search() {
        this.presenter.setTitle(this.termTextBox.getText().trim());
        this.resultPanel.clear();
        String term = this.termTextBox.getText().trim();
        if (term.isEmpty()) {
            this.resultPanel.add((Widget)new SearchResultTable());
            return;
        }
        this.resultPanel.add((Widget)new SearchResultTable(new SearchTermPageRequest(term, 0, null)));
    }

    static interface FullTextSearchFormBinder
    extends UiBinder<Widget, FullTextSearchFormView> {
    }
}

