/*
 * Copyright 2015 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.kie.workbench.common.screens.server.management.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface ServerRef {

    String getId();

    String getUrl();

    String getName();

    String getUsername();

    String getPassword();

    ContainerStatus getStatus();

    ConnectionType getConnectionType();

    Map<String, String> getProperties();

    Collection<ContainerRef> getContainersRef();

    boolean hasContainerRef( final String containerId );

    ContainerRef getContainerRef( final String containerId );

    void addContainerRef( final ContainerRef containerConfig );

    void deleteContainer( String containerId );

    List<ServerInstanceRef> getManagedServers();

    void addManagedServer( final ServerInstanceRef serverInstanceRef );
}
