/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.utils;

import java.util.Properties;
import org.kie.server.common.KeyStoreHelperUtil;

public final class ControllerUtils {
    public static final String KIE_SERVER_CONTROLLER = "org.kie.workbench.controller";
    public static final String CFG_KIE_CONTROLLER_USER = "org.kie.workbench.controller.user";
    public static final String CFG_KIE_CONTROLLER_PASSWORD = "org.kie.workbench.controller.pwd";
    public static final String CFG_KIE_CONTROLLER_TOKEN = "org.kie.workbench.controller.token";
    public static final String CFG_KIE_CONTROLLER_OCP_ENABLED = "org.kie.workbench.controller.openshift.enabled";
    private static ThreadLocal<Properties> configProps;

    private ControllerUtils() {
    }

    public static Properties getConfigProps() {
        return configProps.get();
    }

    public static boolean useEmbeddedController() {
        return ControllerUtils.getControllerURL() == null;
    }

    public static String getControllerURL() {
        return ControllerUtils.getConfigProps().getProperty(KIE_SERVER_CONTROLLER);
    }

    public static String getControllerUser() {
        return ControllerUtils.getConfigProps().getProperty(CFG_KIE_CONTROLLER_USER, "kieserver");
    }

    public static String getControllerPassword() {
        return KeyStoreHelperUtil.loadControllerPassword((String)ControllerUtils.getConfigProps().getProperty(CFG_KIE_CONTROLLER_PASSWORD, "kieserver1!"));
    }

    public static String getControllerToken() {
        return ControllerUtils.getConfigProps().getProperty(CFG_KIE_CONTROLLER_TOKEN);
    }

    public static boolean isOpenShiftSupported() {
        return "true".equals(ControllerUtils.getConfigProps().getProperty(CFG_KIE_CONTROLLER_OCP_ENABLED, "false"));
    }

    static {
        new ThreadLocal();
        configProps = ThreadLocal.withInitial(System::getProperties);
    }
}

