/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.common.services.project.model.GAV;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.workbench.common.screens.server.management.model.ConnectionType;
import org.kie.workbench.common.screens.server.management.model.Container;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ScannerStatus;
import org.kie.workbench.common.screens.server.management.model.Server;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ScannerOperationResult;
import org.kie.workbench.common.screens.server.management.model.impl.ServerImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerRefImpl;
import org.kie.workbench.common.screens.server.management.service.ContainerAlreadyRegisteredException;
import org.kie.workbench.common.screens.server.management.service.RemoteOperationFailedException;
import org.uberfire.commons.data.Pair;

@ApplicationScoped
public class RemoteAccessImpl {
    private static final String BASE_URI = "/services/rest/server";

    public ServerRef toServerRef(String endpoint, String name, String username, String password, ConnectionType connectionType, Collection<ContainerRef> containerRefs) {
        String _version;
        String _endpoint;
        block3: {
            _endpoint = this.cleanup(endpoint);
            KieServicesClient client = new KieServicesClient(_endpoint, username, password);
            _version = null;
            try {
                ServiceResponse response = client.getServerInfo();
                if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    _version = ((KieServerInfo)response.getResult()).getVersion();
                }
            }
            catch (Exception ex) {
                _endpoint = _endpoint.concat(BASE_URI);
                client = new KieServicesClient(_endpoint, username, password);
                ServiceResponse response = client.getServerInfo();
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) break block3;
                _version = ((KieServerInfo)response.getResult()).getVersion();
            }
        }
        final String version = _version;
        return new ServerRefImpl(_endpoint, name, username, password, ContainerStatus.LOADING, connectionType, (Map)new HashMap<String, String>(){
            {
                this.put("version", version);
            }
        }, containerRefs);
    }

    private String cleanup(String endpoint) {
        if (endpoint.endsWith("/")) {
            return this.cleanup(endpoint.substring(0, endpoint.length() - 1));
        }
        return endpoint;
    }

    public Server toServer(String endpoint, String name, String username, String password, ConnectionType connectionType, Collection<ContainerRef> containerRefs) {
        ServerRef serverRef = this.toServerRef(endpoint, name, username, password, connectionType, containerRefs);
        try {
            KieServicesClient client = new KieServicesClient(serverRef.getId(), serverRef.getUsername(), serverRef.getPassword());
            ArrayList<Container> containers = new ArrayList<Container>();
            ServiceResponse containerResourcesResponse = client.listContainers();
            if (containerResourcesResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS) && ((KieContainerResourceList)containerResourcesResponse.getResult()).getContainers() != null) {
                for (KieContainerResource kieContainerResource : ((KieContainerResourceList)containerResourcesResponse.getResult()).getContainers()) {
                    containers.add(this.toContainer(serverRef.getId(), kieContainerResource));
                }
            }
            return new ServerImpl(serverRef.getId(), serverRef.getName(), serverRef.getUsername(), serverRef.getPassword(), ContainerStatus.STARTED, connectionType, containers, serverRef.getProperties(), serverRef.getContainersRef());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Container install(String serverId, String containerId, String username, String password, GAV gav) {
        try {
            KieServicesClient client = new KieServicesClient(serverId, username, password);
            ServiceResponse response = client.createContainer(containerId, new KieContainerResource(new ReleaseId(gav.getGroupId(), gav.getArtifactId(), gav.getVersion())));
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return this.toContainer(serverId, (KieContainerResource)response.getResult());
            }
            throw new ContainerAlreadyRegisteredException(response.getMsg());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean stop(String serverId, String containerId, String username, String password) {
        try {
            KieServicesClient client = new KieServicesClient(serverId, username, password);
            ServiceResponse response = client.updateScanner(containerId, new KieScannerResource(KieScannerStatus.STOPPED));
            return response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Container toContainer(String serverId, KieContainerResource kieContainerResource) {
        return new ContainerImpl(serverId, kieContainerResource.getContainerId(), this.toStatus(kieContainerResource.getStatus()), this.toGAV(kieContainerResource.getReleaseId()), this.toStatus(kieContainerResource.getScanner()), kieContainerResource.getScanner() == null ? null : kieContainerResource.getScanner().getPollInterval(), this.toGAV(kieContainerResource.getResolvedReleaseId()));
    }

    private GAV toGAV(ReleaseId releaseId) {
        return new GAV(releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion());
    }

    public ScannerStatus toStatus(KieScannerResource scanner) {
        if (scanner == null) {
            return ScannerStatus.STOPPED;
        }
        switch (scanner.getStatus()) {
            case UNKNOWN: {
                return ScannerStatus.UNKNOWN;
            }
            case STOPPED: {
                return ScannerStatus.STOPPED;
            }
            case CREATED: {
                return ScannerStatus.CREATED;
            }
            case STARTED: {
                return ScannerStatus.STARTED;
            }
            case SCANNING: {
                return ScannerStatus.SCANNING;
            }
            case DISPOSED: {
                return ScannerStatus.DISPOSED;
            }
        }
        return ScannerStatus.ERROR;
    }

    public ContainerStatus toStatus(KieContainerStatus status) {
        switch (status) {
            case CREATING: {
                return ContainerStatus.LOADING;
            }
            case DISPOSING: {
                return ContainerStatus.STOPPED;
            }
            case STARTED: {
                return ContainerStatus.STARTED;
            }
            case FAILED: {
                return ContainerStatus.ERROR;
            }
        }
        return ContainerStatus.ERROR;
    }

    public boolean deleteContainer(String serverId, String containerId, String username, String password) {
        try {
            KieServicesClient client = new KieServicesClient(serverId, username, password);
            return client.disposeContainer(containerId).getType().equals((Object)ServiceResponse.ResponseType.SUCCESS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean containerExists(String serverId, String containerId, String username, String password) {
        try {
            return new KieServicesClient(serverId, username, password).getContainerInfo(containerId).getType().equals((Object)ServiceResponse.ResponseType.SUCCESS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Server toServer(String endpoint, String name, String username, String password, ConnectionType remote) {
        return this.toServer(endpoint, name, username, password, remote, null);
    }

    public Pair<Boolean, Container> getContainer(String serverId, String containerId, String username, String password) {
        try {
            KieServicesClient client = new KieServicesClient(serverId, username, password);
            ServiceResponse response = client.getContainerInfo(containerId);
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return Pair.newPair((Object)true, (Object)this.toContainer(serverId, (KieContainerResource)response.getResult()));
            }
            return Pair.newPair((Object)true, null);
        }
        catch (Exception ex) {
            return Pair.newPair((Object)false, null);
        }
    }

    public ScannerOperationResult stopScanner(String serverId, String containerId, String username, String password) {
        return this.changeScannerStatus(serverId, containerId, username, password, KieScannerStatus.STOPPED, null);
    }

    public ScannerOperationResult startScanner(String serverId, String containerId, String username, String password, long interval) {
        return this.changeScannerStatus(serverId, containerId, username, password, KieScannerStatus.STARTED, interval);
    }

    public ScannerOperationResult scanNow(String serverId, String containerId, String username, String password) {
        return this.changeScannerStatus(serverId, containerId, username, password, KieScannerStatus.SCANNING, null);
    }

    private ScannerOperationResult changeScannerStatus(String serverId, String containerId, String username, String password, KieScannerStatus status, Long interval) {
        try {
            KieServicesClient client = new KieServicesClient(serverId, username, password);
            KieScannerResource resource = interval == null ? new KieScannerResource(status) : new KieScannerResource(status, interval);
            ServiceResponse response = client.updateScanner(containerId, resource);
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return new ScannerOperationResult(this.toStatus((KieScannerResource)response.getResult()), response.getMsg(), ((KieScannerResource)response.getResult()).getPollInterval());
            }
            return new ScannerOperationResult(ScannerStatus.ERROR, response.getMsg(), null);
        }
        catch (Exception ex) {
            return new ScannerOperationResult(ScannerStatus.ERROR, ex.getMessage(), null);
        }
    }

    public void upgradeContainer(String serverId, String containerId, String username, String password, GAV releaseId) {
        try {
            KieServicesClient client = new KieServicesClient(serverId, username, password);
            ServiceResponse response = client.updateReleaseId(containerId, new ReleaseId(releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion()));
            if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                throw new RemoteOperationFailedException(response.getMsg());
            }
        }
        catch (Exception ex) {
            if (ex instanceof RemoteOperationFailedException) {
                throw (RemoteOperationFailedException)ex;
            }
            throw new RuntimeException(ex.getMessage());
        }
    }
}

