/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.remote.common.rest.RestEasy960Util;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.workbench.common.screens.server.management.backend.ServerReferenceStorageImpl;
import org.kie.workbench.common.screens.server.management.events.ServerConnected;
import org.kie.workbench.common.screens.server.management.events.ServerOnError;
import org.kie.workbench.common.screens.server.management.model.ConnectionType;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.Server;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.kie.workbench.common.screens.server.management.model.impl.ServerImpl;

@Path(value="/controller")
@ApplicationScoped
public class ServerControllerRestImpl {
    @Inject
    private ServerReferenceStorageImpl storage;
    @Inject
    private Event<ServerConnected> serverConnectedEvent;
    @Inject
    private Event<ServerOnError> serverOnErrorEvent;

    @GET
    @Path(value="server/{serverId}")
    @Produces(value={"application/xml", "application/json"})
    public Response syncOnConnect(@Context HttpHeaders headers, @PathParam(value="serverId") String serverId) {
        ArrayList<KieContainerResource> containerResources = new ArrayList<KieContainerResource>();
        ServerRef serverRef = this.storage.loadServerRef(serverId);
        if (serverRef == null) {
            return ServerControllerRestImpl.createCorrectVariant("Server " + serverId + " not found", headers, Response.Status.NOT_FOUND);
        }
        Collection containerRefList = serverRef.getContainersRef();
        for (ContainerRef containerRef : containerRefList) {
            ReleaseId releaseId = new ReleaseId(containerRef.getReleasedId().getGroupId(), containerRef.getReleasedId().getArtifactId(), containerRef.getReleasedId().getVersion());
            containerResources.add(new KieContainerResource(containerRef.getId(), releaseId, containerRef.getStatus() == ContainerStatus.STARTED ? KieContainerStatus.STARTED : KieContainerStatus.FAILED));
        }
        KieContainerResourceList containerResourceList = new KieContainerResourceList();
        containerResourceList.setContainers(containerResources);
        ServerImpl server = new ServerImpl(serverRef.getId(), serverRef.getUrl(), serverRef.getName(), serverRef.getUsername(), serverRef.getPassword(), ContainerStatus.STARTED, ConnectionType.REMOTE, new ArrayList(), serverRef.getProperties(), serverRef.getContainersRef());
        this.serverConnectedEvent.fire((Object)new ServerConnected((Server)server));
        return ServerControllerRestImpl.createCorrectVariant(containerResourceList, headers, Response.Status.OK);
    }

    @POST
    @Path(value="server/{serverId}")
    public Response disconnect(@Context HttpHeaders headers, @PathParam(value="serverId") String serverId) {
        ServerRef serverRef = this.storage.loadServerRef(serverId);
        if (serverRef == null) {
            return ServerControllerRestImpl.createCorrectVariant("Server " + serverId + " not found", headers, Response.Status.NOT_FOUND);
        }
        this.serverOnErrorEvent.fire((Object)new ServerOnError(serverRef, "Server disconnected"));
        return null;
    }

    public static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Response.Status status) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v == null) {
            v = RestEasy960Util.defaultVariant;
        }
        responseBuilder = status != null ? Response.status((Response.Status)status).entity(responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        return responseBuilder.build();
    }
}

