/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.server.management.backend.RemoteAccessImpl;
import org.kie.workbench.common.screens.server.management.backend.ServerReferenceStorageImpl;
import org.kie.workbench.common.screens.server.management.events.ContainerCreated;
import org.kie.workbench.common.screens.server.management.events.ContainerDeleted;
import org.kie.workbench.common.screens.server.management.events.ContainerStarted;
import org.kie.workbench.common.screens.server.management.events.ContainerStopped;
import org.kie.workbench.common.screens.server.management.events.ContainerUpdated;
import org.kie.workbench.common.screens.server.management.events.ServerConnected;
import org.kie.workbench.common.screens.server.management.events.ServerDeleted;
import org.kie.workbench.common.screens.server.management.events.ServerOnError;
import org.kie.workbench.common.screens.server.management.model.ConnectionType;
import org.kie.workbench.common.screens.server.management.model.Container;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ScannerStatus;
import org.kie.workbench.common.screens.server.management.model.Server;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerRefImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ScannerOperationResult;
import org.kie.workbench.common.screens.server.management.model.impl.ServerRefImpl;
import org.kie.workbench.common.screens.server.management.service.ContainerAlreadyRegisteredException;
import org.kie.workbench.common.screens.server.management.service.ServerAlreadyRegisteredException;
import org.kie.workbench.common.screens.server.management.service.ServerManagementService;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;

@Service
@ApplicationScoped
public class ServerManagementServiceImpl
implements ServerManagementService {
    private Event<ServerConnected> serverConnectedEvent;
    private Event<ServerOnError> serverOnErrorEvent;
    private Event<ServerDeleted> serverDeletedEvent;
    private Event<ContainerCreated> containerCreatedEvent;
    private Event<ContainerStarted> containerStartedEvent;
    private Event<ContainerStopped> containerStoppedEvent;
    private Event<ContainerDeleted> containerDeletedEvent;
    private Event<ContainerUpdated> containerUpdatedEvent;
    private ServerReferenceStorageImpl storage;
    private RemoteAccessImpl remoteAccess;
    private Executor executor;

    public ServerManagementServiceImpl() {
    }

    @Inject
    public ServerManagementServiceImpl(Event<ServerConnected> serverConnectedEvent, Event<ServerOnError> serverOnErrorEvent, Event<ServerDeleted> serverDeletedEvent, Event<ContainerCreated> containerCreatedEvent, Event<ContainerStarted> containerStartedEvent, Event<ContainerStopped> containerStoppedEvent, Event<ContainerDeleted> containerDeletedEvent, Event<ContainerUpdated> containerUpdatedEvent, ServerReferenceStorageImpl storage, RemoteAccessImpl remoteAccess) {
        this(serverConnectedEvent, serverOnErrorEvent, serverDeletedEvent, containerCreatedEvent, containerStartedEvent, containerStoppedEvent, containerDeletedEvent, containerUpdatedEvent, storage, remoteAccess, (Executor)SimpleAsyncExecutorService.getDefaultInstance());
    }

    public ServerManagementServiceImpl(Event<ServerConnected> serverConnectedEvent, Event<ServerOnError> serverOnErrorEvent, Event<ServerDeleted> serverDeletedEvent, Event<ContainerCreated> containerCreatedEvent, Event<ContainerStarted> containerStartedEvent, Event<ContainerStopped> containerStoppedEvent, Event<ContainerDeleted> containerDeletedEvent, Event<ContainerUpdated> containerUpdatedEvent, ServerReferenceStorageImpl storage, RemoteAccessImpl remoteAccess, Executor executor) {
        this.serverConnectedEvent = serverConnectedEvent;
        this.serverOnErrorEvent = serverOnErrorEvent;
        this.serverDeletedEvent = serverDeletedEvent;
        this.containerCreatedEvent = containerCreatedEvent;
        this.containerStartedEvent = containerStartedEvent;
        this.containerStoppedEvent = containerStoppedEvent;
        this.containerDeletedEvent = containerDeletedEvent;
        this.containerUpdatedEvent = containerUpdatedEvent;
        this.storage = storage;
        this.remoteAccess = remoteAccess;
        this.executor = executor;
    }

    public void refresh() {
        this.listServers();
    }

    public Collection<ServerRef> listServers() {
        Collection<ServerRef> result = this.storage.listRegisteredServers();
        for (final ServerRef serverRef : result) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Server server = ServerManagementServiceImpl.this.remoteAccess.toServer(serverRef);
                        if (server == null) {
                            ServerManagementServiceImpl.this.serverOnErrorEvent.fire((Object)new ServerOnError(ServerManagementServiceImpl.this.toError(serverRef), ""));
                        } else {
                            ServerManagementServiceImpl.this.storage.forceRegister((ServerRef)server);
                            ServerManagementServiceImpl.this.serverConnectedEvent.fire((Object)new ServerConnected(server));
                        }
                    }
                    catch (Exception ex) {
                        ServerManagementServiceImpl.this.serverOnErrorEvent.fire((Object)new ServerOnError(ServerManagementServiceImpl.this.toError(serverRef), ""));
                    }
                }
            });
        }
        return result;
    }

    private ServerRef toError(ServerRef serverRef) {
        return new ServerRefImpl(serverRef.getId(), serverRef.getUrl(), serverRef.getName(), serverRef.getUsername(), serverRef.getPassword(), ContainerStatus.ERROR, serverRef.getConnectionType(), serverRef.getProperties(), serverRef.getContainersRef());
    }

    public void registerServer(String endpoint, String name, String username, String password, String controllerUrl) throws ServerAlreadyRegisteredException {
        PortablePreconditions.checkNotEmpty((String)"endpoint", (String)endpoint);
        PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        PortablePreconditions.checkNotEmpty((String)"controllerUrl", (String)controllerUrl);
        Server server = this.remoteAccess.registerServer(endpoint, name, username, password, ConnectionType.REMOTE, controllerUrl);
        if (this.storage.exists((ServerRef)server)) {
            throw new ServerAlreadyRegisteredException("Server already registered.");
        }
        if (server != null) {
            this.storage.register((ServerRef)server);
            this.serverConnectedEvent.fire((Object)new ServerConnected(server));
        }
    }

    public void startContainers(Map<String, List<String>> containers) {
        for (Map.Entry<String, List<String>> entry : containers.entrySet()) {
            ServerRef serverRef = this.storage.loadServerRef(entry.getKey());
            for (String containerId : entry.getValue()) {
                ContainerRef containerRef = serverRef.getContainerRef(containerId);
                Container container = this.remoteAccess.install(serverRef.getId(), serverRef.getUrl(), containerRef.getId(), serverRef.getUsername(), serverRef.getPassword(), containerRef.getReleasedId());
                this.containerStartedEvent.fire((Object)new ContainerStarted(container));
            }
        }
    }

    public void stopContainers(Map<String, List<String>> containers) {
        for (Map.Entry<String, List<String>> entry : containers.entrySet()) {
            ServerRef serverRef = this.storage.loadServerRef(entry.getKey());
            for (String containerId : entry.getValue()) {
                ContainerRef containerRef = serverRef.getContainerRef(containerId);
                ContainerRefImpl newContainerRef = new ContainerRefImpl(containerRef.getServerId(), containerRef.getId(), ContainerStatus.STOPPED, containerRef.getReleasedId(), containerRef.getScannerStatus(), containerRef.getPollInterval());
                serverRef.deleteContainer(containerRef.getId());
                serverRef.addContainerRef((ContainerRef)newContainerRef);
                this.storage.forceRegister(serverRef);
                this.remoteAccess.deleteContainer(serverRef.getUrl(), containerRef.getId(), serverRef.getUsername(), serverRef.getPassword());
                this.containerStoppedEvent.fire((Object)new ContainerStopped((ContainerRef)newContainerRef));
            }
        }
    }

    public void createContainer(String serverId, String containerId, GAV gav) {
        ServerRef serverRef = this.storage.loadServerRef(serverId);
        try {
            if (this.remoteAccess.containerExists(serverRef.getUrl(), containerId, serverRef.getUsername(), serverRef.getPassword())) {
                throw new ContainerAlreadyRegisteredException(containerId);
            }
        }
        catch (ContainerAlreadyRegisteredException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        ContainerRefImpl containerRef = new ContainerRefImpl(serverId, containerId, ContainerStatus.STOPPED, gav, null, null);
        this.storage.createContainer((ContainerRef)containerRef);
        this.containerCreatedEvent.fire((Object)new ContainerCreated((ContainerRef)containerRef));
    }

    public Container getContainerInfo(String serverId, String container) {
        ServerRef serverRef = this.storage.loadServerRef(serverId);
        Pair<Boolean, Container> result = this.remoteAccess.getContainer(serverRef.getId(), serverRef.getUrl(), container, serverRef.getUsername(), serverRef.getPassword());
        if (result.getK2() != null) {
            return (Container)result.getK2();
        }
        ContainerRef containerRef = this.storage.loadServerRef(serverId).getContainerRef(container);
        return new ContainerImpl(containerRef.getServerId(), containerRef.getId(), (Boolean)result.getK1() != false ? containerRef.getStatus() : ContainerStatus.ERROR, containerRef.getReleasedId(), null, containerRef.getPollInterval(), null);
    }

    public ScannerOperationResult scanNow(String serverId, String containerId) {
        ServerRef serverRef = this.storage.loadServerRef(serverId);
        ScannerOperationResult resource = this.remoteAccess.scanNow(serverRef.getUrl(), containerId, serverRef.getUsername(), serverRef.getPassword());
        if (resource != null && resource.getScannerStatus().equals((Object)ScannerStatus.SCANNING)) {
            this.refresh();
        }
        return resource;
    }

    public ScannerOperationResult startScanner(String serverId, String containerId, long interval) {
        ServerRef serverRef = this.storage.loadServerRef(serverId);
        this.storage.updateContainer(serverId, containerId, interval);
        return this.remoteAccess.startScanner(serverRef.getUrl(), containerId, serverRef.getUsername(), serverRef.getPassword(), interval);
    }

    public ScannerOperationResult stopScanner(String serverId, String containerId) {
        ServerRef serverRef = this.storage.loadServerRef(serverId);
        return this.remoteAccess.stopScanner(serverRef.getUrl(), containerId, serverRef.getUsername(), serverRef.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeContainer(String serverId, String containerId, GAV releaseId) {
        ServerRef serverRef = this.storage.loadServerRef(serverId);
        try {
            this.remoteAccess.upgradeContainer(serverRef.getUrl(), containerId, serverRef.getUsername(), serverRef.getPassword(), releaseId);
            this.storage.updateContainer(serverId, containerId, releaseId);
        }
        finally {
            this.containerUpdatedEvent.fire((Object)new ContainerUpdated(this.getContainerInfo(serverId, containerId)));
        }
    }

    public void deleteOp(Collection<String> servers2Unregister, Map<String, List<String>> containers2delete) {
        for (Map.Entry<String, List<String>> stringListEntry : containers2delete.entrySet()) {
            for (String containerId : stringListEntry.getValue()) {
                this.deleteContainer(stringListEntry.getKey(), containerId);
            }
        }
        for (String server2Unregister : servers2Unregister) {
            this.unregisterServer(server2Unregister);
        }
    }

    private void deleteContainer(String serverId, String containerId) {
        ServerRef serverRef = this.storage.loadServerRef(serverId);
        this.storage.deleteContainer(serverId, containerId);
        this.remoteAccess.deleteContainer(serverRef.getUrl(), containerId, serverRef.getUsername(), serverRef.getPassword());
        this.containerDeletedEvent.fire((Object)new ContainerDeleted(serverId, containerId));
    }

    private void unregisterServer(String id) {
        this.storage.unregister((ServerRef)new ServerRefImpl(id, "", "--none--", null, null, null, null, null, null));
        this.serverDeletedEvent.fire((Object)new ServerDeleted(id));
    }
}

