/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import com.thoughtworks.xstream.XStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.GAV;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerRefImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerRefImpl;
import org.kie.workbench.common.screens.server.management.service.ContainerAlreadyRegisteredException;
import org.kie.workbench.common.screens.server.management.service.ContainerNotFoundException;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class ServerReferenceStorageImpl {
    private IOService ioService;
    private FileSystem fileSystem;
    private final XStream xs = new XStream();

    public ServerReferenceStorageImpl() {
    }

    @Inject
    public ServerReferenceStorageImpl(@Named(value="configIO") IOService ioService, @Named(value="systemFS") FileSystem fileSystem) {
        this.ioService = ioService;
        this.fileSystem = fileSystem;
    }

    public boolean exists(ServerRef serverRef) {
        return this.ioService.exists(this.buildPath(serverRef));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRegister(ServerRef serverRef) {
        Path path = this.buildPath(serverRef);
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ServerRef serverRef) {
        if (!this.exists(serverRef)) {
            Path path = this.buildPath(serverRef);
            try {
                this.ioService.startBatch(path.getFileSystem());
                this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
            }
            finally {
                this.ioService.endBatch();
            }
        } else {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ServerRef> listRegisteredServers() {
        ArrayList<ServerRef> result = new ArrayList<ServerRef>();
        Path dir = this.buildPath((String)null);
        try {
            this.ioService.startBatch(dir.getFileSystem());
            for (Path registeredServer : this.ioService.newDirectoryStream(dir)) {
                try {
                    result.add(this.restoreConfig(registeredServer));
                }
                catch (Exception ignore) {
                    this.ioService.delete(registeredServer, new DeleteOption[0]);
                }
            }
            ArrayList<ServerRef> i$ = result;
            return i$;
        }
        catch (NotDirectoryException ignore) {
            ArrayList<ServerRef> arrayList = result;
            return arrayList;
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private ServerRef restoreConfig(Path registeredServer) {
        try {
            ServerRef serverRef = (ServerRef)this.xs.fromXML(this.ioService.readAllString(registeredServer));
            return new ServerRefImpl(serverRef.getId(), serverRef.getUrl(), serverRef.getName(), serverRef.getUsername(), serverRef.getPassword(), ContainerStatus.LOADING, serverRef.getConnectionType(), serverRef.getProperties(), serverRef.getContainersRef());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ServerRef serverRef) {
        Path path = this.buildPath(serverRef);
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.delete(path, new DeleteOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    Path buildPath(ServerRef serverRef) {
        if (serverRef == null) {
            return this.buildPath((String)null);
        }
        return this.buildPath(serverRef.getId());
    }

    Path buildPath(String endpoint) {
        if (endpoint != null) {
            return this.fileSystem.getPath("servers", new String[]{"remote", this.toHex(endpoint) + ".xml"});
        }
        return this.fileSystem.getPath("servers", new String[]{"remote"});
    }

    public String toHex(String arg) {
        if (this.isHex(arg)) {
            return arg;
        }
        return String.format("%x", new BigInteger(1, arg.toLowerCase().getBytes(Charset.forName("UTF-8"))));
    }

    private boolean isHex(String endpoint) {
        try {
            new BigInteger(endpoint, 16);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContainer(ContainerRef containerRef) {
        Path path = this.buildPath(containerRef.getServerId());
        try {
            this.ioService.startBatch(path.getFileSystem());
            ServerRef serverRef = this.loadServerRef(containerRef.getServerId());
            if (serverRef != null) {
                if (serverRef.hasContainerRef(containerRef.getId())) {
                    throw new ContainerAlreadyRegisteredException(containerRef.getId());
                }
                serverRef.addContainerRef(containerRef);
                this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
            }
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public ServerRef loadServerRef(String serverId) {
        Path path = this.buildPath(serverId);
        return this.restoreConfig(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContainer(String serverId, String containerId) {
        Path path = this.buildPath(serverId);
        ServerRef serverRef = this.loadServerRef(serverId);
        if (serverRef != null) {
            serverRef.deleteContainer(containerId);
            try {
                this.ioService.startBatch(path.getFileSystem());
                this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContainer(String serverId, String containerId, GAV releaseId) {
        Path path = this.buildPath(serverId);
        ServerRef serverRef = this.loadServerRef(serverId);
        if (serverRef != null) {
            ContainerRef containerRef = serverRef.getContainerRef(containerId);
            if (containerRef == null) {
                throw new ContainerNotFoundException(containerId);
            }
            serverRef.deleteContainer(containerId);
            serverRef.addContainerRef((ContainerRef)new ContainerRefImpl(serverId, containerId, containerRef.getStatus(), releaseId, containerRef.getScannerStatus(), containerRef.getPollInterval()));
            try {
                this.ioService.startBatch(path.getFileSystem());
                this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContainer(String serverId, String containerId, Long pollInterval) {
        Path path = this.buildPath(serverId);
        ServerRef serverRef = this.loadServerRef(serverId);
        if (serverRef != null) {
            ContainerRef containerRef = serverRef.getContainerRef(containerId);
            if (containerRef == null) {
                throw new ContainerNotFoundException(containerId);
            }
            serverRef.deleteContainer(containerId);
            serverRef.addContainerRef((ContainerRef)new ContainerRefImpl(serverId, containerId, containerRef.getStatus(), containerRef.getReleasedId(), containerRef.getScannerStatus(), pollInterval));
            try {
                this.ioService.startBatch(path.getFileSystem());
                this.ioService.write(path, this.xs.toXML((Object)serverRef), new OpenOption[0]);
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }
}

