/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerControllerAdmin;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.storage.KieServerControllerStorage;
import org.kie.server.controller.rest.RestKieServerControllerImpl;
import org.kie.workbench.common.screens.server.management.events.ServerConnected;
import org.kie.workbench.common.screens.server.management.events.ServerDisconnected;
import org.kie.workbench.common.screens.server.management.model.ConnectionType;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ScannerStatus;
import org.kie.workbench.common.screens.server.management.model.Server;
import org.kie.workbench.common.screens.server.management.model.ServerInstanceRef;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerRefImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerInstanceRefImpl;

@ApplicationScoped
public class KieServerWBControllerImpl
extends RestKieServerControllerImpl {
    @Inject
    private Event<ServerConnected> serverConnectedEvent;
    @Inject
    private Event<ServerDisconnected> serverDisconnectedEvent;
    @Inject
    private KieServerControllerAdmin controllerAdmin;

    @Inject
    public void setStorage(KieServerControllerStorage storage) {
        super.setStorage(storage);
    }

    public KieServerSetup connect(KieServerInfo serverInfo) {
        KieServerSetup kieServerSetup = super.connect(serverInfo);
        KieServerInstance kieServerInstance = this.controllerAdmin.getKieServerInstance(serverInfo.getServerId());
        this.serverConnectedEvent.fire((Object)new ServerConnected(this.buildServer(kieServerInstance)));
        return kieServerSetup;
    }

    public void disconnect(KieServerInfo serverInfo) {
        super.disconnect(serverInfo);
        KieServerInstance kieServerInstance = this.controllerAdmin.getKieServerInstance(serverInfo.getServerId());
        this.serverDisconnectedEvent.fire((Object)new ServerDisconnected(this.buildServer(kieServerInstance)));
    }

    protected Server buildServer(final KieServerInstance kieServerInstance) {
        ServerImpl serverRef = new ServerImpl(kieServerInstance.getIdentifier(), "", kieServerInstance.getName(), "user", "password", kieServerInstance.getStatus().equals((Object)KieServerStatus.DOWN) ? ContainerStatus.STOPPED : ContainerStatus.STARTED, ConnectionType.REMOTE, null, (Map)new HashMap<String, String>(){
            {
                this.put("version", kieServerInstance.getVersion());
            }
        }, null);
        if (kieServerInstance.getKieServerSetup() != null && kieServerInstance.getKieServerSetup().getContainers() != null) {
            Set containerResources = kieServerInstance.getKieServerSetup().getContainers();
            for (KieContainerResource containerResource : containerResources) {
                GAV gav = new GAV(containerResource.getReleaseId().getGroupId(), containerResource.getReleaseId().getArtifactId(), containerResource.getReleaseId().getVersion());
                ContainerRefImpl containerRef = new ContainerRefImpl(serverRef.getId(), containerResource.getContainerId(), containerResource.getStatus().equals((Object)KieContainerStatus.STARTED) ? ContainerStatus.STARTED : ContainerStatus.STOPPED, gav, containerResource.getScanner() == null ? null : ScannerStatus.valueOf((String)containerResource.getScanner().getStatus().toString()), containerResource.getScanner() == null ? null : containerResource.getScanner().getPollInterval());
                serverRef.addContainerRef((ContainerRef)containerRef);
            }
        }
        if (kieServerInstance.getManagedInstances() != null) {
            for (KieServerInstanceInfo instanceInfo : kieServerInstance.getManagedInstances()) {
                ServerInstanceRefImpl instanceRef = new ServerInstanceRefImpl(instanceInfo.getStatus().toString(), instanceInfo.getLocation());
                serverRef.addManagedServer((ServerInstanceRef)instanceRef);
            }
        }
        return serverRef;
    }
}

