/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerControllerAdmin;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.storage.KieServerControllerStorage;
import org.kie.server.controller.rest.RestKieServerControllerImpl;
import org.kie.workbench.common.screens.server.management.backend.ServerUtility;
import org.kie.workbench.common.screens.server.management.events.ServerConnected;
import org.kie.workbench.common.screens.server.management.events.ServerDisconnected;

@ApplicationScoped
public class KieServerWBControllerImpl
extends RestKieServerControllerImpl {
    @Inject
    private Event<ServerConnected> serverConnectedEvent;
    @Inject
    private Event<ServerDisconnected> serverDisconnectedEvent;
    @Inject
    private KieServerControllerAdmin controllerAdmin;

    @Inject
    public void setStorage(KieServerControllerStorage storage) {
        super.setStorage(storage);
    }

    public KieServerSetup connect(KieServerInfo serverInfo) {
        KieServerSetup kieServerSetup = super.connect(serverInfo);
        KieServerInstance kieServerInstance = this.controllerAdmin.getKieServerInstance(serverInfo.getServerId());
        this.serverConnectedEvent.fire((Object)new ServerConnected(ServerUtility.buildServer(kieServerInstance)));
        return kieServerSetup;
    }

    public void disconnect(KieServerInfo serverInfo) {
        super.disconnect(serverInfo);
        KieServerInstance kieServerInstance = this.controllerAdmin.getKieServerInstance(serverInfo.getServerId());
        this.serverDisconnectedEvent.fire((Object)new ServerDisconnected(ServerUtility.buildServer(kieServerInstance)));
    }
}

