/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.common.services.project.model.GAV;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesFactory;
import org.kie.workbench.common.screens.server.management.model.ConnectionType;
import org.kie.workbench.common.screens.server.management.model.Container;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ScannerStatus;
import org.kie.workbench.common.screens.server.management.model.Server;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ScannerOperationResult;
import org.kie.workbench.common.screens.server.management.model.impl.ServerImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerRefImpl;
import org.kie.workbench.common.screens.server.management.service.ContainerAlreadyRegisteredException;
import org.kie.workbench.common.screens.server.management.service.RemoteOperationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.data.Pair;

@ApplicationScoped
public class RemoteAccessImpl {
    private static final Logger logger = LoggerFactory.getLogger(RemoteAccessImpl.class);
    private static final String BASE_URI = "/services/rest/server";

    public Server registerServer(String endpoint, String name, String username, String password, ConnectionType connectionType, String controllerUrl) {
        String _endpoint = this.cleanup(endpoint);
        KieServerConfig kieServerConfig = new KieServerConfig();
        kieServerConfig.addConfigItem(new KieServerConfigItem("executor.interval", "2", Integer.class.getName()));
        KieServicesClient client = this.getKieServicesClient(username, password, _endpoint);
        String _version = null;
        String _id = _endpoint;
        ArrayList<Container> containers = new ArrayList<Container>();
        ServiceResponse containerResourcesResponse = client.listContainers();
        if (containerResourcesResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS) && ((KieContainerResourceList)containerResourcesResponse.getResult()).getContainers() != null) {
            for (KieContainerResource kieContainerResource : ((KieContainerResourceList)containerResourcesResponse.getResult()).getContainers()) {
                containers.add(this.toContainer(_id, kieContainerResource));
            }
        }
        final String version = _version;
        return new ServerImpl(_id, _endpoint, name, username, password, ContainerStatus.STARTED, connectionType, containers, (Map)new HashMap<String, String>(){
            {
                this.put("version", version);
            }
        }, null);
    }

    String addBaseURIToEndpoint(String _endpoint) {
        return _endpoint.concat(BASE_URI);
    }

    KieServicesClient getKieServicesClient(String username, String password, String _endpoint) {
        return KieServicesFactory.newKieServicesRestClient((String)_endpoint, (String)username, (String)password);
    }

    public ServerRef toServerRef(String endpoint, String name, String username, String password, ConnectionType connectionType, Collection<ContainerRef> containerRefs) {
        String _id;
        String _version;
        String _endpoint;
        block3: {
            _endpoint = this.cleanup(endpoint);
            KieServicesClient client = this.getKieServicesClient(username, password, _endpoint);
            _version = null;
            _id = _endpoint;
            try {
                ServiceResponse response = client.getServerInfo();
                if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    _version = ((KieServerInfo)response.getResult()).getVersion();
                    _id = ((KieServerInfo)response.getResult()).getServerId();
                }
            }
            catch (Exception ex) {
                _endpoint = this.addBaseURIToEndpoint(_endpoint);
                client = this.getKieServicesClient(username, password, _endpoint);
                ServiceResponse response = client.getServerInfo();
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) break block3;
                _version = ((KieServerInfo)response.getResult()).getVersion();
                _id = ((KieServerInfo)response.getResult()).getServerId();
            }
        }
        final String version = _version;
        return new ServerRefImpl(_id, _endpoint, name, username, password, ContainerStatus.LOADING, connectionType, (Map)new HashMap<String, String>(){
            {
                this.put("version", version);
            }
        }, containerRefs);
    }

    String encodeController(String controllerUrl) {
        if (controllerUrl != null) {
            try {
                controllerUrl = URLEncoder.encode(controllerUrl, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.debug("Unsupported encoding when encoding controller {}", (Object)controllerUrl, (Object)e);
            }
        }
        return controllerUrl;
    }

    String cleanup(String endpoint) {
        if (endpoint.endsWith("/")) {
            return this.cleanup(endpoint.substring(0, endpoint.length() - 1));
        }
        return endpoint;
    }

    public boolean pingServer(String endpoint, String username, String password) {
        try {
            KieServicesClient client = this.getKieServicesClient(username, password, endpoint);
            ArrayList containers = new ArrayList();
            ServiceResponse containerResourcesResponse = client.getServerInfo();
            if (containerResourcesResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.warn("Ping to server {} failed due to {}", (Object)endpoint, (Object)ex.getMessage());
        }
        return false;
    }

    public Server toServer(String endpoint, String name, String username, String password, ConnectionType connectionType, Collection<ContainerRef> containerRefs) {
        ServerRef serverRef = this.toServerRef(endpoint, name, username, password, connectionType, containerRefs);
        try {
            KieServicesClient client = this.getKieServicesClient(serverRef.getUsername(), serverRef.getPassword(), serverRef.getUrl());
            ArrayList<Container> containers = new ArrayList<Container>();
            ServiceResponse containerResourcesResponse = client.listContainers();
            if (containerResourcesResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS) && ((KieContainerResourceList)containerResourcesResponse.getResult()).getContainers() != null) {
                for (KieContainerResource kieContainerResource : ((KieContainerResourceList)containerResourcesResponse.getResult()).getContainers()) {
                    containers.add(this.toContainer(serverRef.getId(), kieContainerResource));
                }
            }
            return new ServerImpl(serverRef.getId(), serverRef.getUrl(), serverRef.getName(), serverRef.getUsername(), serverRef.getPassword(), ContainerStatus.STARTED, connectionType, containers, serverRef.getProperties(), serverRef.getContainersRef());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Server toServer(ServerRef serverRef) {
        try {
            KieServicesClient client = this.getKieServicesClient(serverRef.getUsername(), serverRef.getPassword(), serverRef.getUrl());
            ArrayList<Object> containers = new ArrayList<Object>();
            ServiceResponse containerResourcesResponse = client.listContainers();
            if (containerResourcesResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS) && ((KieContainerResourceList)containerResourcesResponse.getResult()).getContainers() != null) {
                for (KieContainerResource kieContainerResource : ((KieContainerResourceList)containerResourcesResponse.getResult()).getContainers()) {
                    Container container = this.toContainer(serverRef.getId(), kieContainerResource);
                    if (container.getReleasedId() != null && !container.getStatus().equals((Object)ContainerStatus.ERROR)) {
                        containers.add(container);
                        continue;
                    }
                    ContainerRef containerRef = serverRef.getContainerRef(kieContainerResource.getContainerId());
                    containers.add(new ContainerImpl(containerRef.getServerId(), containerRef.getId(), ContainerStatus.ERROR, containerRef.getReleasedId(), ScannerStatus.ERROR, null, null));
                }
            }
            return new ServerImpl(serverRef.getId(), serverRef.getUrl(), serverRef.getName(), serverRef.getUsername(), serverRef.getPassword(), ContainerStatus.STARTED, ConnectionType.REMOTE, containers, serverRef.getProperties(), serverRef.getContainersRef());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Container install(String serverId, String serverUrl, String containerId, String username, String password, GAV gav) {
        try {
            KieServicesClient client = this.getKieServicesClient(username, password, serverUrl);
            ServiceResponse response = client.createContainer(containerId, new KieContainerResource(new ReleaseId(gav.getGroupId(), gav.getArtifactId(), gav.getVersion())));
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return this.toContainer(serverId, (KieContainerResource)response.getResult());
            }
            throw new ContainerAlreadyRegisteredException(response.getMsg());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean stop(String serverId, String serverUrl, String containerId, String username, String password) {
        try {
            KieServicesClient client = this.getKieServicesClient(username, password, serverId);
            ServiceResponse response = client.updateScanner(containerId, new KieScannerResource(KieScannerStatus.STOPPED));
            return response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    Container toContainer(String serverId, KieContainerResource kieContainerResource) {
        return new ContainerImpl(serverId, kieContainerResource.getContainerId(), this.toStatus(kieContainerResource.getStatus()), this.toGAV(kieContainerResource.getReleaseId()), this.toStatus(kieContainerResource.getScanner()), kieContainerResource.getScanner() == null ? null : Long.valueOf(this.toSeconds(kieContainerResource.getScanner().getPollInterval())), this.toGAV(kieContainerResource.getResolvedReleaseId()));
    }

    private GAV toGAV(ReleaseId releaseId) {
        if (releaseId == null || releaseId.getGroupId() == null) {
            return null;
        }
        return new GAV(releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion());
    }

    public ScannerStatus toStatus(KieScannerResource scanner) {
        if (scanner == null) {
            return ScannerStatus.STOPPED;
        }
        switch (scanner.getStatus()) {
            case UNKNOWN: {
                return ScannerStatus.UNKNOWN;
            }
            case STOPPED: {
                return ScannerStatus.STOPPED;
            }
            case CREATED: {
                return ScannerStatus.CREATED;
            }
            case STARTED: {
                return ScannerStatus.STARTED;
            }
            case SCANNING: {
                return ScannerStatus.SCANNING;
            }
            case DISPOSED: {
                return ScannerStatus.DISPOSED;
            }
        }
        return ScannerStatus.ERROR;
    }

    public ContainerStatus toStatus(KieContainerStatus status) {
        switch (status) {
            case CREATING: {
                return ContainerStatus.LOADING;
            }
            case DISPOSING: {
                return ContainerStatus.STOPPED;
            }
            case STARTED: {
                return ContainerStatus.STARTED;
            }
            case FAILED: {
                return ContainerStatus.ERROR;
            }
        }
        return ContainerStatus.ERROR;
    }

    public boolean deleteContainer(String serverUrl, String containerId, String username, String password) {
        try {
            KieServicesClient client = this.getKieServicesClient(username, password, serverUrl);
            return client.disposeContainer(containerId).getType().equals((Object)ServiceResponse.ResponseType.SUCCESS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean containerExists(String serverUrl, String containerId, String username, String password) {
        try {
            return this.getKieServicesClient(username, password, serverUrl).getContainerInfo(containerId).getType().equals((Object)ServiceResponse.ResponseType.SUCCESS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Server toServer(String endpoint, String name, String username, String password, ConnectionType remote) {
        return this.toServer(endpoint, name, username, password, remote, null);
    }

    public Pair<Boolean, Container> getContainer(String serverId, String serverUrl, String containerId, String username, String password) {
        try {
            KieServicesClient client = this.getKieServicesClient(username, password, serverUrl);
            ServiceResponse response = client.getContainerInfo(containerId);
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return Pair.newPair((Object)true, (Object)this.toContainer(serverId, (KieContainerResource)response.getResult()));
            }
            return Pair.newPair((Object)true, null);
        }
        catch (Exception exception) {
            return Pair.newPair((Object)false, null);
        }
    }

    public ScannerOperationResult stopScanner(String serverId, String containerId, String username, String password) {
        return this.changeScannerStatus(serverId, containerId, username, password, KieScannerStatus.STOPPED, null);
    }

    public ScannerOperationResult startScanner(String serverId, String containerId, String username, String password, long interval) {
        return this.changeScannerStatus(serverId, containerId, username, password, KieScannerStatus.STARTED, interval);
    }

    public ScannerOperationResult scanNow(String serverId, String containerId, String username, String password) {
        return this.changeScannerStatus(serverId, containerId, username, password, KieScannerStatus.SCANNING, null);
    }

    private ScannerOperationResult changeScannerStatus(String serverId, String containerId, String username, String password, KieScannerStatus status, Long interval) {
        try {
            KieServicesClient client = this.getKieServicesClient(username, password, serverId);
            KieScannerResource resource = interval == null ? new KieScannerResource(status) : new KieScannerResource(status, Long.valueOf(this.toMillis(interval)));
            ServiceResponse response = client.updateScanner(containerId, resource);
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                return new ScannerOperationResult(this.toStatus((KieScannerResource)response.getResult()), response.getMsg(), ((KieScannerResource)response.getResult()).getPollInterval());
            }
            return new ScannerOperationResult(ScannerStatus.ERROR, response.getMsg(), null);
        }
        catch (Exception ex) {
            return new ScannerOperationResult(ScannerStatus.ERROR, ex.getMessage(), null);
        }
    }

    public void upgradeContainer(String serverId, String containerId, String username, String password, GAV releaseId) {
        try {
            KieServicesClient client = this.getKieServicesClient(username, password, serverId);
            ServiceResponse response = client.updateReleaseId(containerId, new ReleaseId(releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion()));
            if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                throw new RemoteOperationFailedException(response.getMsg());
            }
        }
        catch (Exception ex) {
            if (ex instanceof RemoteOperationFailedException) {
                throw (RemoteOperationFailedException)ex;
            }
            throw new RuntimeException(ex.getMessage());
        }
    }

    private long toMillis(Long duration) {
        if (duration == null) {
            return 0L;
        }
        return TimeUnit.SECONDS.toMillis(duration);
    }

    private long toSeconds(Long duration) {
        if (duration == null) {
            return 0L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(duration);
    }
}

