/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.remote.common.rest.KieRemoteHttpRequestException;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.client.KieServicesException;
import org.kie.server.controller.api.KieServerControllerAdmin;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.storage.KieServerControllerStorage;
import org.kie.server.controller.rest.ControllerUtils;
import org.kie.workbench.common.screens.server.management.backend.RemoteAccessImpl;
import org.kie.workbench.common.screens.server.management.backend.ServerReferenceStorageImpl;
import org.kie.workbench.common.screens.server.management.backend.ServerUtility;
import org.kie.workbench.common.screens.server.management.events.ContainerCreated;
import org.kie.workbench.common.screens.server.management.events.ContainerDeleted;
import org.kie.workbench.common.screens.server.management.events.ContainerOnError;
import org.kie.workbench.common.screens.server.management.events.ContainerStarted;
import org.kie.workbench.common.screens.server.management.events.ContainerStopped;
import org.kie.workbench.common.screens.server.management.events.ContainerUpdated;
import org.kie.workbench.common.screens.server.management.events.ServerConnected;
import org.kie.workbench.common.screens.server.management.events.ServerDeleted;
import org.kie.workbench.common.screens.server.management.events.ServerDisconnected;
import org.kie.workbench.common.screens.server.management.events.ServerOnError;
import org.kie.workbench.common.screens.server.management.model.ConnectionType;
import org.kie.workbench.common.screens.server.management.model.Container;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ScannerStatus;
import org.kie.workbench.common.screens.server.management.model.Server;
import org.kie.workbench.common.screens.server.management.model.ServerInstanceRef;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerRefImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ScannerOperationResult;
import org.kie.workbench.common.screens.server.management.model.impl.ServerImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerInstanceRefImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerRefImpl;
import org.kie.workbench.common.screens.server.management.service.ServerAlreadyRegisteredException;
import org.kie.workbench.common.screens.server.management.service.ServerManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DisposableExecutor;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.validation.PortablePreconditions;

@Service
@ApplicationScoped
public class ServerManagementServiceImpl
implements ServerManagementService {
    private static final Logger logger = LoggerFactory.getLogger(ServerManagementServiceImpl.class);
    private Event<ServerConnected> serverConnectedEvent;
    private Event<ServerDisconnected> serverDisconnectedEvent;
    private Event<ServerOnError> serverOnErrorEvent;
    private Event<ServerDeleted> serverDeletedEvent;
    private Event<ContainerCreated> containerCreatedEvent;
    private Event<ContainerStarted> containerStartedEvent;
    private Event<ContainerStopped> containerStoppedEvent;
    private Event<ContainerDeleted> containerDeletedEvent;
    private Event<ContainerUpdated> containerUpdatedEvent;
    private Event<ContainerOnError> containerOnErrorEvent;
    private ServerReferenceStorageImpl storage;
    private RemoteAccessImpl remoteAccess;
    private DisposableExecutor executor;
    private KieServerControllerAdmin controllerAdmin;
    private KieServerControllerStorage controllerStorage;

    public ServerManagementServiceImpl() {
    }

    @Inject
    public ServerManagementServiceImpl(Event<ServerConnected> serverConnectedEvent, Event<ServerOnError> serverOnErrorEvent, Event<ServerDeleted> serverDeletedEvent, Event<ContainerCreated> containerCreatedEvent, Event<ContainerStarted> containerStartedEvent, Event<ContainerStopped> containerStoppedEvent, Event<ContainerDeleted> containerDeletedEvent, Event<ContainerUpdated> containerUpdatedEvent, Event<ContainerOnError> containerOnErrorEvent, Event<ServerDisconnected> serverDisconnectedEvent, ServerReferenceStorageImpl storage, RemoteAccessImpl remoteAccess, KieServerControllerAdmin controllerAdmin, KieServerControllerStorage controllerStorage) {
        this(serverConnectedEvent, serverOnErrorEvent, serverDeletedEvent, containerCreatedEvent, containerStartedEvent, containerStoppedEvent, containerDeletedEvent, containerUpdatedEvent, containerOnErrorEvent, serverDisconnectedEvent, storage, remoteAccess, controllerAdmin, controllerStorage, SimpleAsyncExecutorService.getDefaultInstance());
    }

    public ServerManagementServiceImpl(Event<ServerConnected> serverConnectedEvent, Event<ServerOnError> serverOnErrorEvent, Event<ServerDeleted> serverDeletedEvent, Event<ContainerCreated> containerCreatedEvent, Event<ContainerStarted> containerStartedEvent, Event<ContainerStopped> containerStoppedEvent, Event<ContainerDeleted> containerDeletedEvent, Event<ContainerUpdated> containerUpdatedEvent, Event<ContainerOnError> containerOnErrorEvent, Event<ServerDisconnected> serverDisconnectedEvent, ServerReferenceStorageImpl storage, RemoteAccessImpl remoteAccess, KieServerControllerAdmin controllerAdmin, KieServerControllerStorage controllerStorage, DisposableExecutor executor) {
        this.serverConnectedEvent = serverConnectedEvent;
        this.serverOnErrorEvent = serverOnErrorEvent;
        this.serverDeletedEvent = serverDeletedEvent;
        this.containerCreatedEvent = containerCreatedEvent;
        this.containerStartedEvent = containerStartedEvent;
        this.containerStoppedEvent = containerStoppedEvent;
        this.containerDeletedEvent = containerDeletedEvent;
        this.containerUpdatedEvent = containerUpdatedEvent;
        this.containerOnErrorEvent = containerOnErrorEvent;
        this.serverDisconnectedEvent = serverDisconnectedEvent;
        this.storage = storage;
        this.remoteAccess = remoteAccess;
        this.controllerAdmin = controllerAdmin;
        this.controllerStorage = controllerStorage;
        this.executor = executor;
    }

    public void refresh() {
        this.listServers();
    }

    public Collection<ServerRef> listServers() {
        ArrayList<ServerRef> result = new ArrayList<ServerRef>();
        List instances = this.controllerAdmin.listKieServerInstances();
        for (final KieServerInstance instance : instances) {
            ServerRefImpl serverRef = new ServerRefImpl(instance.getIdentifier(), "url", instance.getName(), "user", "password", instance.getStatus().equals((Object)KieServerStatus.DOWN) ? ContainerStatus.STOPPED : ContainerStatus.STARTED, ConnectionType.REMOTE, (Map)new HashMap<String, String>(){
                {
                    this.put("version", instance.getVersion());
                }
            }, null);
            if (instance.getKieServerSetup() != null && instance.getKieServerSetup().getContainers() != null) {
                Set containerResources = instance.getKieServerSetup().getContainers();
                for (KieContainerResource containerResource : containerResources) {
                    GAV gav = new GAV(containerResource.getReleaseId().getGroupId(), containerResource.getReleaseId().getArtifactId(), containerResource.getReleaseId().getVersion());
                    ContainerRefImpl containerRef = new ContainerRefImpl(serverRef.getId(), containerResource.getContainerId(), this.calculateStatus(containerResource, instance), gav, containerResource.getScanner() == null ? null : ScannerStatus.valueOf((String)containerResource.getScanner().getStatus().toString()), containerResource.getScanner() == null ? null : containerResource.getScanner().getPollInterval());
                    serverRef.addContainerRef((ContainerRef)containerRef);
                }
            }
            if (instance.getManagedInstances() != null) {
                for (KieServerInstanceInfo instanceInfo : instance.getManagedInstances()) {
                    ServerInstanceRefImpl instanceRef = new ServerInstanceRefImpl(instanceInfo.getStatus().toString(), instanceInfo.getLocation());
                    serverRef.addManagedServer((ServerInstanceRef)instanceRef);
                }
            }
            result.add((ServerRef)serverRef);
        }
        return result;
    }

    public void registerServer(String endpoint, String name, String version) throws ServerAlreadyRegisteredException {
        PortablePreconditions.checkNotEmpty((String)"endpoint", (String)endpoint);
        PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        try {
            final KieServerInfo kieServerInfo = new KieServerInfo();
            kieServerInfo.setServerId(endpoint);
            kieServerInfo.setName(name);
            kieServerInfo.setVersion(version);
            this.controllerAdmin.addKieServerInstance(kieServerInfo);
            ServerImpl serverRef = new ServerImpl(kieServerInfo.getServerId(), "url", kieServerInfo.getName(), "user", "password", ContainerStatus.STOPPED, ConnectionType.REMOTE, null, (Map)new HashMap<String, String>(){
                {
                    this.put("version", kieServerInfo.getVersion());
                }
            }, null);
            this.serverConnectedEvent.fire((Object)new ServerConnected((Server)serverRef));
        }
        catch (KieServicesException e) {
            logger.warn("Connection failed", (Throwable)e);
            throw e;
        }
        catch (KieRemoteHttpRequestException e) {
            logger.warn("Connection failed", (Throwable)e);
            throw e;
        }
    }

    private KieContainerResource findContainerById(String containerId, Set<KieContainerResource> containerResources) {
        if (containerResources != null) {
            for (KieContainerResource containerResource : containerResources) {
                if (!containerResource.getContainerId().equals(containerId)) continue;
                return containerResource;
            }
        }
        return null;
    }

    private GAV toGAV(ReleaseId releaseId) {
        return new GAV(releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion());
    }

    public void startContainers(Map<String, List<String>> containers) {
        for (Map.Entry<String, List<String>> entry : containers.entrySet()) {
            final KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(entry.getKey());
            Set containerResources = serverInstance.getKieServerSetup().getContainers();
            for (String containerId : entry.getValue()) {
                final KieContainerResource containerRef = this.findContainerById(containerId, containerResources);
                containerRef.setStatus(KieContainerStatus.STARTED);
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                            try {
                                ServerManagementServiceImpl.this.remoteAccess.install(serverInstance.getIdentifier(), instanceInfo.getLocation(), containerRef.getContainerId(), ControllerUtils.getUser(), ControllerUtils.getPassword(), ServerManagementServiceImpl.this.toGAV(containerRef.getReleaseId()));
                            }
                            catch (Exception ex) {
                                logger.debug("Error while broadcasting start container request to server instance {}", (Object)instanceInfo.getLocation(), (Object)ex);
                            }
                        }
                    }
                });
                ContainerImpl newContainerRef = new ContainerImpl(serverInstance.getIdentifier(), containerRef.getContainerId(), ContainerStatus.STARTED, this.toGAV(containerRef.getReleaseId()), containerRef.getScanner() == null ? null : ScannerStatus.valueOf((String)containerRef.getScanner().getStatus().toString()), containerRef.getScanner() == null ? null : containerRef.getScanner().getPollInterval(), this.toGAV(containerRef.getReleaseId()));
                if (serverInstance.getManagedInstances() != null) {
                    for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                        ServerInstanceRefImpl instanceRef = new ServerInstanceRefImpl(instanceInfo.getStatus().toString(), instanceInfo.getLocation());
                        newContainerRef.addManagedServer((ServerInstanceRef)instanceRef);
                    }
                }
                this.containerStartedEvent.fire((Object)new ContainerStarted((Container)newContainerRef));
            }
            this.controllerStorage.update(serverInstance);
        }
    }

    public void stopContainers(Map<String, List<String>> containers) {
        for (Map.Entry<String, List<String>> entry : containers.entrySet()) {
            final KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(entry.getKey());
            Set containerResources = serverInstance.getKieServerSetup().getContainers();
            for (String containerId : entry.getValue()) {
                final KieContainerResource containerRef = this.findContainerById(containerId, containerResources);
                containerRef.setStatus(KieContainerStatus.STOPPED);
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                            try {
                                ServerManagementServiceImpl.this.remoteAccess.deleteContainer(instanceInfo.getLocation(), containerRef.getContainerId(), ControllerUtils.getUser(), ControllerUtils.getPassword());
                            }
                            catch (Exception ex) {
                                logger.debug("Error while broadcasting stop container request to server instance {}", (Object)instanceInfo.getLocation(), (Object)ex);
                            }
                        }
                    }
                });
                ContainerRefImpl newContainerRef = new ContainerRefImpl(serverInstance.getIdentifier(), containerRef.getContainerId(), ContainerStatus.STOPPED, this.toGAV(containerRef.getReleaseId()), containerRef.getScanner() == null ? null : ScannerStatus.valueOf((String)containerRef.getScanner().getStatus().toString()), containerRef.getScanner() == null ? null : containerRef.getScanner().getPollInterval());
                if (serverInstance.getManagedInstances() != null) {
                    for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                        ServerInstanceRefImpl instanceRef = new ServerInstanceRefImpl(instanceInfo.getStatus().toString(), instanceInfo.getLocation());
                        newContainerRef.addManagedServer((ServerInstanceRef)instanceRef);
                    }
                }
                this.containerStoppedEvent.fire((Object)new ContainerStopped((ContainerRef)newContainerRef));
            }
            this.controllerStorage.update(serverInstance);
        }
    }

    public void createContainer(String serverId, String containerId, GAV gav) {
        KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(serverId);
        KieContainerResource containerResource = new KieContainerResource(containerId, new ReleaseId(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()));
        containerResource.setStatus(KieContainerStatus.STOPPED);
        serverInstance.getKieServerSetup().getContainers().add(containerResource);
        this.controllerStorage.update(serverInstance);
        ContainerRefImpl containerRef = new ContainerRefImpl(serverId, containerId, ContainerStatus.STOPPED, gav, null, null);
        this.containerCreatedEvent.fire((Object)new ContainerCreated((ContainerRef)containerRef));
    }

    public Container getContainerInfo(String serverId, String container) {
        KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(serverId);
        KieContainerResource containerResource = this.findContainerById(container, serverInstance.getKieServerSetup().getContainers());
        ContainerImpl containerInstance = new ContainerImpl(serverId, containerResource.getContainerId(), this.calculateStatus(containerResource, serverInstance), this.toGAV(containerResource.getReleaseId()), containerResource.getScanner() == null ? null : ScannerStatus.valueOf((String)containerResource.getScanner().getStatus().toString()), containerResource.getScanner() == null ? null : containerResource.getScanner().getPollInterval(), null);
        if (serverInstance.getManagedInstances() != null) {
            for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                ServerInstanceRefImpl instanceRef = new ServerInstanceRefImpl(instanceInfo.getStatus().toString(), instanceInfo.getLocation());
                containerInstance.addManagedServer((ServerInstanceRef)instanceRef);
            }
        }
        return containerInstance;
    }

    protected ContainerStatus calculateStatus(KieContainerResource containerResource, KieServerInstance kieServerInstance) {
        if (containerResource.getStatus().equals((Object)KieContainerStatus.STOPPED) || kieServerInstance.getStatus().equals((Object)KieServerStatus.DOWN)) {
            return ContainerStatus.STOPPED;
        }
        return ContainerStatus.STARTED;
    }

    public ScannerOperationResult scanNow(String serverId, String containerId) {
        final KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(serverId);
        final KieContainerResource containerResource = this.findContainerById(containerId, serverInstance.getKieServerSetup().getContainers());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                    try {
                        ServerManagementServiceImpl.this.remoteAccess.scanNow(instanceInfo.getLocation(), containerResource.getContainerId(), ControllerUtils.getUser(), ControllerUtils.getPassword());
                    }
                    catch (Exception ex) {
                        logger.debug("Error while broadcasting start scanning now request to server instance {}", (Object)instanceInfo.getLocation(), (Object)ex);
                    }
                }
                ServerManagementServiceImpl.this.refresh();
            }
        });
        return new ScannerOperationResult(ScannerStatus.SCANNING, "Scanning operation initiated on all servers", null);
    }

    public ScannerOperationResult startScanner(String serverId, String containerId, final long interval) {
        final KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(serverId);
        final KieContainerResource containerResource = this.findContainerById(containerId, serverInstance.getKieServerSetup().getContainers());
        KieScannerResource kieScannerResource = containerResource.getScanner();
        if (kieScannerResource == null) {
            kieScannerResource = new KieScannerResource();
            containerResource.setScanner(kieScannerResource);
        }
        kieScannerResource.setPollInterval(Long.valueOf(interval));
        kieScannerResource.setStatus(KieScannerStatus.STARTED);
        this.controllerStorage.update(serverInstance);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                    try {
                        ServerManagementServiceImpl.this.remoteAccess.startScanner(instanceInfo.getLocation(), containerResource.getContainerId(), ControllerUtils.getUser(), ControllerUtils.getPassword(), interval);
                    }
                    catch (Exception ex) {
                        logger.debug("Error while broadcasting start scanning with interval request to server instance {}", (Object)instanceInfo.getLocation(), (Object)ex);
                    }
                }
            }
        });
        return new ScannerOperationResult(ScannerStatus.STARTED, "Scanner start initiated on all servers with interval " + interval, null);
    }

    public ScannerOperationResult stopScanner(String serverId, String containerId) {
        final KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(serverId);
        final KieContainerResource containerResource = this.findContainerById(containerId, serverInstance.getKieServerSetup().getContainers());
        KieScannerResource kieScannerResource = containerResource.getScanner();
        if (kieScannerResource == null) {
            kieScannerResource = new KieScannerResource();
            containerResource.setScanner(kieScannerResource);
        }
        kieScannerResource.setStatus(KieScannerStatus.STOPPED);
        this.controllerStorage.update(serverInstance);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                    try {
                        ServerManagementServiceImpl.this.remoteAccess.stopScanner(instanceInfo.getLocation(), containerResource.getContainerId(), ControllerUtils.getUser(), ControllerUtils.getPassword());
                    }
                    catch (Exception ex) {
                        logger.debug("Error while broadcasting stop scanning request to server instance {}", (Object)instanceInfo.getLocation(), (Object)ex);
                    }
                }
            }
        });
        return new ScannerOperationResult(ScannerStatus.STOPPED, "Scanner stop initiated on all servers", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeContainer(String serverId, final String containerId, final GAV releaseId) {
        final KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(serverId);
        try {
            KieContainerResource containerResource = this.findContainerById(containerId, serverInstance.getKieServerSetup().getContainers());
            containerResource.setReleaseId(new ReleaseId(releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion()));
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                        try {
                            ServerManagementServiceImpl.this.remoteAccess.upgradeContainer(instanceInfo.getLocation(), containerId, ControllerUtils.getUser(), ControllerUtils.getPassword(), releaseId);
                        }
                        catch (Exception ex) {
                            logger.debug("Error while broadcasting update container request to server instance {}", (Object)instanceInfo.getLocation(), (Object)ex);
                        }
                    }
                }
            });
            this.controllerStorage.update(serverInstance);
        }
        finally {
            this.containerUpdatedEvent.fire((Object)new ContainerUpdated(this.getContainerInfo(serverId, containerId)));
        }
    }

    public void updateServerStatus(Collection<String> servers) {
        for (String serverId : servers) {
            final KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(serverId);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                        try {
                            boolean alive = ServerManagementServiceImpl.this.remoteAccess.pingServer(instanceInfo.getLocation(), ControllerUtils.getUser(), ControllerUtils.getPassword());
                            if (alive) {
                                instanceInfo.setStatus(KieServerStatus.UP);
                                continue;
                            }
                            instanceInfo.setStatus(KieServerStatus.DOWN);
                        }
                        catch (Exception ex) {
                            logger.debug("Error while pinging server instance {}", (Object)instanceInfo.getLocation(), (Object)ex);
                        }
                    }
                    ServerManagementServiceImpl.this.controllerStorage.update(serverInstance);
                    Server serverRef = ServerUtility.buildServer(serverInstance);
                    if (serverInstance.getStatus().equals((Object)KieServerStatus.DOWN)) {
                        ServerManagementServiceImpl.this.serverDisconnectedEvent.fire((Object)new ServerDisconnected(serverRef));
                    } else {
                        ServerManagementServiceImpl.this.serverConnectedEvent.fire((Object)new ServerConnected(serverRef));
                    }
                }
            });
        }
    }

    public void deleteOp(Collection<String> servers2Unregister, Map<String, List<String>> containers2delete) {
        for (Map.Entry<String, List<String>> stringListEntry : containers2delete.entrySet()) {
            for (String containerId : stringListEntry.getValue()) {
                this.deleteContainer(stringListEntry.getKey(), containerId);
            }
        }
        for (String server2Unregister : servers2Unregister) {
            this.unregisterServer(server2Unregister);
        }
    }

    private void deleteContainer(String serverId, final String containerId) {
        final KieServerInstance serverInstance = this.controllerAdmin.getKieServerInstance(serverId);
        KieContainerResource containerResource = this.findContainerById(containerId, serverInstance.getKieServerSetup().getContainers());
        serverInstance.getKieServerSetup().getContainers().remove(containerResource);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (KieServerInstanceInfo instanceInfo : serverInstance.getManagedInstances()) {
                    try {
                        ServerManagementServiceImpl.this.remoteAccess.deleteContainer(instanceInfo.getLocation(), containerId, ControllerUtils.getUser(), ControllerUtils.getPassword());
                    }
                    catch (Exception ex) {
                        logger.debug("Error while broadcasting delete container request to server instance {}", (Object)instanceInfo.getLocation(), (Object)ex);
                    }
                }
            }
        });
        this.controllerStorage.update(serverInstance);
        this.containerDeletedEvent.fire((Object)new ContainerDeleted(serverId, containerId));
    }

    private void unregisterServer(String id) {
        this.controllerStorage.delete(id);
        this.serverDeletedEvent.fire((Object)new ServerDeleted(id));
    }
}

