/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.guvnor.common.services.project.model.GAV;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.workbench.common.screens.server.management.model.ConnectionType;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ScannerStatus;
import org.kie.workbench.common.screens.server.management.model.Server;
import org.kie.workbench.common.screens.server.management.model.ServerInstanceRef;
import org.kie.workbench.common.screens.server.management.model.impl.ContainerRefImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerImpl;
import org.kie.workbench.common.screens.server.management.model.impl.ServerInstanceRefImpl;

public class ServerUtility {
    public static Server buildServer(final KieServerInstance kieServerInstance) {
        ServerImpl serverRef = new ServerImpl(kieServerInstance.getIdentifier(), "", kieServerInstance.getName(), "user", "password", kieServerInstance.getStatus().equals((Object)KieServerStatus.DOWN) ? ContainerStatus.STOPPED : ContainerStatus.STARTED, ConnectionType.REMOTE, null, (Map)new HashMap<String, String>(){
            {
                this.put("version", kieServerInstance.getVersion());
            }
        }, null);
        if (kieServerInstance.getKieServerSetup() != null && kieServerInstance.getKieServerSetup().getContainers() != null) {
            Set containerResources = kieServerInstance.getKieServerSetup().getContainers();
            for (KieContainerResource containerResource : containerResources) {
                GAV gav = new GAV(containerResource.getReleaseId().getGroupId(), containerResource.getReleaseId().getArtifactId(), containerResource.getReleaseId().getVersion());
                ContainerRefImpl containerRef = new ContainerRefImpl(serverRef.getId(), containerResource.getContainerId(), KieContainerStatus.STARTED.equals((Object)containerResource.getStatus()) ? ContainerStatus.STARTED : ContainerStatus.STOPPED, gav, containerResource.getScanner() == null ? null : ScannerStatus.valueOf((String)containerResource.getScanner().getStatus().toString()), containerResource.getScanner() == null ? null : containerResource.getScanner().getPollInterval());
                serverRef.addContainerRef((ContainerRef)containerRef);
            }
        }
        if (kieServerInstance.getManagedInstances() != null) {
            for (KieServerInstanceInfo instanceInfo : kieServerInstance.getManagedInstances()) {
                ServerInstanceRefImpl instanceRef = new ServerInstanceRefImpl(instanceInfo.getStatus().toString(), instanceInfo.getLocation());
                serverRef.addManagedServer((ServerInstanceRef)instanceRef);
            }
        }
        return serverRef;
    }
}

