/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import com.thoughtworks.xstream.XStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.storage.KieServerControllerStorage;
import org.kie.workbench.common.screens.server.management.model.ContainerRef;
import org.kie.workbench.common.screens.server.management.model.ContainerStatus;
import org.kie.workbench.common.screens.server.management.model.ScannerStatus;
import org.kie.workbench.common.screens.server.management.model.ServerRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class VFSKieServerControllerStorage
implements KieServerControllerStorage {
    private static final Logger logger = LoggerFactory.getLogger(VFSKieServerControllerStorage.class);
    private IOService ioService;
    private FileSystem fileSystem;
    private final XStream xs = new XStream();

    public VFSKieServerControllerStorage() {
    }

    @Inject
    public VFSKieServerControllerStorage(@Named(value="configIO") IOService ioService, @Named(value="systemFS") FileSystem fileSystem) {
        this.ioService = ioService;
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KieServerInstance store(KieServerInstance kieServerInstance) {
        Path path = this.buildPath(kieServerInstance);
        if (!this.ioService.exists(path)) {
            try {
                this.ioService.startBatch(path.getFileSystem());
                this.ioService.write(path, this.xs.toXML((Object)kieServerInstance), new OpenOption[0]);
            }
            finally {
                this.ioService.endBatch();
            }
            return kieServerInstance;
        }
        throw new IllegalArgumentException("KieServerInstance with id " + kieServerInstance.getIdentifier() + " is already stored");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KieServerInstance> load() {
        ArrayList<KieServerInstance> result = new ArrayList<KieServerInstance>();
        Path dir = this.buildPath((String)null);
        try {
            this.ioService.startBatch(dir.getFileSystem());
            for (Path registeredServer : this.ioService.newDirectoryStream(dir)) {
                try {
                    this.migrate(registeredServer);
                    result.add(this.readKieServerInstance(registeredServer));
                }
                catch (Exception ignore) {
                    this.ioService.delete(registeredServer, new DeleteOption[0]);
                }
            }
            ArrayList<KieServerInstance> i$ = result;
            return i$;
        }
        catch (NotDirectoryException ignore) {
            ArrayList<KieServerInstance> arrayList = result;
            return arrayList;
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public KieServerInstance load(String identifier) {
        Path path = this.buildPath(identifier);
        this.migrate(path);
        KieServerInstance serverInstance = this.readKieServerInstance(path);
        return serverInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KieServerInstance update(KieServerInstance kieServerInstance) {
        Path path = this.buildPath(kieServerInstance);
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.write(path, this.xs.toXML((Object)kieServerInstance), new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
        return kieServerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KieServerInstance delete(String identifier) {
        Path path = this.buildPath(identifier);
        KieServerInstance serverInstance = null;
        try {
            this.ioService.startBatch(path.getFileSystem());
            serverInstance = this.readKieServerInstance(path);
            this.ioService.delete(path, new DeleteOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
        return serverInstance;
    }

    private KieServerInstance readKieServerInstance(Path registeredServer) {
        try {
            if (this.ioService.exists(registeredServer)) {
                KieServerInstance serverInstance = (KieServerInstance)this.xs.fromXML(this.ioService.readAllString(registeredServer));
                return serverInstance;
            }
        }
        catch (Exception ex) {
            logger.error("Error reading KieServerInstance definition from path {}", (Object)registeredServer, (Object)ex);
        }
        return null;
    }

    Path buildPath(KieServerInstance kieServerInstance) {
        if (kieServerInstance == null) {
            return this.buildPath((String)null);
        }
        return this.buildPath(kieServerInstance.getIdentifier());
    }

    Path buildPath(String identifier) {
        if (identifier != null) {
            return this.fileSystem.getPath("servers", new String[]{"remote", this.toHex(identifier) + "-info.xml"});
        }
        return this.fileSystem.getPath("servers", new String[]{"remote"});
    }

    public String toHex(String arg) {
        if (this.isHex(arg)) {
            return arg;
        }
        return String.format("%x", new BigInteger(1, arg.toLowerCase().getBytes(Charset.forName("UTF-8"))));
    }

    private boolean isHex(String endpoint) {
        try {
            new BigInteger(endpoint, 16);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrate(Path path) {
        if (!path.toString().endsWith("-info.xml")) {
            try {
                ServerRef serverRef = (ServerRef)this.xs.fromXML(this.ioService.readAllString(path));
                KieServerInstance kieServerInstance = new KieServerInstance();
                kieServerInstance.setIdentifier(serverRef.getId());
                kieServerInstance.setVersion((String)serverRef.getProperties().get("version"));
                kieServerInstance.setName(serverRef.getName());
                kieServerInstance.setStatus(serverRef.getStatus().equals((Object)ContainerStatus.STARTED) ? KieServerStatus.UP : KieServerStatus.DOWN);
                KieServerSetup kieServerSetup = new KieServerSetup();
                HashSet<KieContainerResource> containerResources = new HashSet<KieContainerResource>();
                Collection containersRef = serverRef.getContainersRef();
                if (containersRef != null) {
                    for (ContainerRef containerRef : containersRef) {
                        KieContainerResource containerResource = new KieContainerResource();
                        containerResource.setContainerId(containerRef.getId());
                        containerResource.setReleaseId(new ReleaseId(containerRef.getReleasedId().getGroupId(), containerRef.getReleasedId().getArtifactId(), containerRef.getReleasedId().getVersion()));
                        containerResource.setStatus(serverRef.getStatus().equals((Object)ContainerStatus.STARTED) ? KieContainerStatus.STARTED : KieContainerStatus.STOPPED);
                        Long scannerInterval = containerRef.getPollInterval();
                        ScannerStatus scannerStatus = containerRef.getScannerStatus();
                        if (scannerInterval != null && scannerStatus != null) {
                            KieScannerResource scannerResource = new KieScannerResource();
                            scannerResource.setPollInterval(scannerInterval);
                            scannerResource.setStatus(KieScannerStatus.valueOf((String)scannerStatus.toString()));
                            containerResource.setScanner(scannerResource);
                        }
                        containerResources.add(containerResource);
                    }
                }
                kieServerSetup.setContainers(containerResources);
                KieServerInstanceInfo instanceInfo = new KieServerInstanceInfo();
                instanceInfo.setLocation(serverRef.getUrl());
                instanceInfo.setStatus(serverRef.getStatus().equals((Object)ContainerStatus.STARTED) ? KieServerStatus.UP : KieServerStatus.DOWN);
                kieServerInstance.getManagedInstances().add(instanceInfo);
                this.store(kieServerInstance);
                try {
                    this.ioService.startBatch(path.getFileSystem());
                    this.ioService.delete(path, new DeleteOption[0]);
                }
                finally {
                    this.ioService.endBatch();
                }
            }
            catch (Exception ex) {
                logger.error("Error wile migrating old version of kie server ref from path {}", (Object)path, (Object)ex);
            }
        }
    }
}

