/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.uberfire.commons.async.DisposableExecutor;
import org.uberfire.commons.async.SimpleAsyncExecutorService;

@ApplicationScoped
public class AsyncKieServerInstanceManager
extends KieServerInstanceManager {
    private DisposableExecutor executor;
    @Inject
    private NotificationService notificationService;

    @PostConstruct
    public void configure() {
        this.executor = SimpleAsyncExecutorService.getDefaultInstance();
    }

    public List<Container> startScanner(final ServerTemplate serverTemplate, final ContainerSpec containerSpec, final long interval) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.startScanner(serverTemplate, containerSpec, interval);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> stopScanner(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.stopScanner(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> scanNow(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.scanNow(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> startContainer(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.startContainer(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> stopContainer(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.stopContainer(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> upgradeContainer(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.upgradeContainer(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> getContainers(final ServerInstanceKey serverInstanceKey) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.getContainers(serverInstanceKey);
                ServerInstance serverInstance = new ServerInstance();
                serverInstance.setServerName(serverInstanceKey.getServerName());
                serverInstance.setServerTemplateId(serverInstanceKey.getServerTemplateId());
                serverInstance.setServerInstanceId(serverInstanceKey.getServerInstanceId());
                serverInstance.setUrl(serverInstanceKey.getUrl());
                serverInstance.setContainers((Collection)containers);
                AsyncKieServerInstanceManager.this.notificationService.notify(new ServerInstanceUpdated(serverInstance));
            }
        });
        return Collections.emptyList();
    }

    public List<Container> getContainers(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.getContainers(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
            }
        });
        return Collections.emptyList();
    }
}

