/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.rest;

import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.kie.server.controller.rest.RestKieServerControllerImpl;
import org.kie.server.controller.rest.RestRuntimeManagementServiceImpl;
import org.kie.server.controller.rest.RestSpecManagementServiceImpl;
import org.kie.workbench.common.screens.server.management.backend.rest.StandaloneControllerFilter;
import org.kie.workbench.common.screens.server.management.backend.utils.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class StandaloneControllerDynamicFeature
implements DynamicFeature {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneControllerDynamicFeature.class);

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (ControllerUtils.useEmbeddedController()) {
            return;
        }
        if (resourceInfo.getResourceClass().isAssignableFrom(RestKieServerControllerImpl.class)) {
            this.registerFilter(resourceInfo.getResourceClass(), context);
        } else if (resourceInfo.getResourceClass().isAssignableFrom(RestSpecManagementServiceImpl.class)) {
            this.registerFilter(resourceInfo.getResourceClass(), context);
        } else if (resourceInfo.getResourceClass().isAssignableFrom(RestRuntimeManagementServiceImpl.class)) {
            this.registerFilter(resourceInfo.getResourceClass(), context);
        }
    }

    private void registerFilter(Class resourceClass, FeatureContext context) {
        LOGGER.debug("Adding standalone controller REST filter to resource class: {}", (Object)resourceClass);
        context.register(StandaloneControllerFilter.class);
    }
}

