/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.websocket;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.server.controller.api.model.events.ContainerSpecUpdated;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.client.event.EventHandler;
import org.kie.workbench.common.screens.server.management.backend.utils.StandaloneController;
import org.kie.workbench.common.screens.server.management.model.ContainerSpecData;

@ApplicationScoped
@StandaloneController
public class StandaloneNotificationService
implements EventHandler {
    @Inject
    private Event<ServerTemplateUpdated> serverTemplateUpdatedEvent;
    @Inject
    private Event<ServerTemplateDeleted> serverTemplateDeletedEvent;
    @Inject
    private Event<ServerInstanceUpdated> serverInstanceUpdatedEvent;
    @Inject
    private Event<ServerInstanceDeleted> serverInstanceDeletedEvent;
    @Inject
    private Event<ServerInstanceConnected> serverInstanceConnectedEvent;
    @Inject
    private Event<ServerInstanceDisconnected> serverInstanceDisconnectedEvent;
    @Inject
    private Event<ContainerSpecData> containerSpecDataEvent;

    public void onServerInstanceConnected(ServerInstanceConnected serverInstanceConnected) {
        this.serverInstanceConnectedEvent.fire((Object)serverInstanceConnected);
    }

    public void onServerInstanceDeleted(ServerInstanceDeleted serverInstanceDeleted) {
        this.serverInstanceDeletedEvent.fire((Object)serverInstanceDeleted);
    }

    public void onServerInstanceDisconnected(ServerInstanceDisconnected serverInstanceDisconnected) {
        this.serverInstanceDisconnectedEvent.fire((Object)serverInstanceDisconnected);
    }

    public void onServerTemplateDeleted(ServerTemplateDeleted serverTemplateDeleted) {
        this.serverTemplateDeletedEvent.fire((Object)serverTemplateDeleted);
    }

    public void onServerTemplateUpdated(ServerTemplateUpdated serverTemplateUpdated) {
        this.serverTemplateUpdatedEvent.fire((Object)serverTemplateUpdated);
    }

    public void onServerInstanceUpdated(ServerInstanceUpdated serverInstanceUpdated) {
        this.serverInstanceUpdatedEvent.fire((Object)serverInstanceUpdated);
    }

    public void onContainerSpecUpdated(ContainerSpecUpdated containerSpecUpdated) {
        ContainerSpecData containerSpecData = new ContainerSpecData(containerSpecUpdated.getContainerSpec(), (Collection)containerSpecUpdated.getContainers());
        this.containerSpecDataEvent.fire((Object)containerSpecData);
    }
}

