/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.controller.client.KieServerControllerClientFactory;
import org.kie.server.controller.client.event.EventHandler;
import org.kie.workbench.common.screens.server.management.backend.utils.ControllerUtils;
import org.kie.workbench.common.screens.server.management.backend.utils.StandaloneController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@StandaloneController
public class KieServerStandaloneControllerProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerStandaloneControllerProducer.class);

    @Produces
    @ApplicationScoped
    @StandaloneController
    public KieServerControllerClient produceKieServerControllerClient(@StandaloneController EventHandler handler) {
        LOGGER.debug("Creating KieServerControllerClient...");
        String controllerURL = ControllerUtils.getControllerURL();
        KieServerStandaloneControllerProducer.validateProtocol(controllerURL);
        LOGGER.info("Using standalone controller url: {}", (Object)controllerURL);
        String token = ControllerUtils.getControllerToken();
        if (token == null) {
            return KieServerControllerClientFactory.newWebSocketClient((String)controllerURL, (String)ControllerUtils.getControllerUser(), (String)ControllerUtils.getControllerPassword(), (EventHandler)handler);
        }
        return KieServerControllerClientFactory.newWebSocketClient((String)controllerURL, (String)token, (EventHandler)handler);
    }

    protected static void validateProtocol(String controllerURL) {
        if (!controllerURL.startsWith("ws:")) {
            throw new RuntimeException("Invalid protocol for connecting with remote standalone controller, only Web Socket connections are supported");
        }
    }
}

