/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.service;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.server.controller.api.KieServerControllerIllegalArgumentException;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKeyList;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.api.service.SpecManagementService;

@Service
@ApplicationScoped
public class SpecManagementServiceCDI
implements org.kie.workbench.common.screens.server.management.service.SpecManagementService {
    @Inject
    @Any
    private SpecManagementService service;

    public void deleteServerInstance(ServerInstanceKey serverInstanceKey) {
        this.service.deleteServerInstance(serverInstanceKey);
    }

    public boolean isContainerIdValid(String serverTemplateId, String containerId) {
        if (!this.isValidIdentifier(containerId)) {
            return false;
        }
        ServerTemplate template = this.getServerTemplate(serverTemplateId);
        if (template == null) {
            throw new RuntimeException("Server template doesn't exists");
        }
        return template.getContainerSpec(containerId) == null;
    }

    public String validContainerId(String serverTemplateId, String containerId) {
        if (this.isContainerIdValid(serverTemplateId, containerId)) {
            return containerId;
        }
        return this.validContainerIdWithSuffix(serverTemplateId, containerId);
    }

    public boolean isNewServerTemplateIdValid(String serverTemplateId) {
        try {
            ServerTemplate serverTemplate = this.getServerTemplate(serverTemplateId);
            return serverTemplate == null;
        }
        catch (KieServerControllerIllegalArgumentException notFoundException) {
            return true;
        }
    }

    private String validContainerIdWithSuffix(String serverTemplateId, String containerId) {
        int attemptNumber = 2;
        while (!this.isContainerIdValid(serverTemplateId, containerId + "-" + attemptNumber)) {
            ++attemptNumber;
        }
        return containerId + "-" + attemptNumber;
    }

    private boolean isValidIdentifier(String identifier) {
        return identifier != null && identifier.matches("[A-Za-z0-9_\\-.:]+");
    }

    public void saveContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        this.service.saveContainerSpec(serverTemplateId, containerSpec);
    }

    public void saveServerTemplate(ServerTemplate serverTemplate) {
        this.service.saveServerTemplate(serverTemplate);
    }

    public ServerTemplate getServerTemplate(String serverTemplateId) {
        return this.service.getServerTemplate(serverTemplateId);
    }

    public ServerTemplateKeyList listServerTemplateKeys() {
        return this.service.listServerTemplateKeys();
    }

    public ServerTemplateList listServerTemplates() {
        return this.service.listServerTemplates();
    }

    public void deleteContainerSpec(String serverTemplateId, String containerSpecId) {
        this.service.deleteContainerSpec(serverTemplateId, containerSpecId);
    }

    public void deleteServerTemplate(String serverTemplateId) {
        this.service.deleteServerTemplate(serverTemplateId);
    }

    public void copyServerTemplate(String serverTemplateId, String newServerTemplateId, String newServerTemplateName) {
        this.service.copyServerTemplate(serverTemplateId, newServerTemplateId, newServerTemplateName);
    }

    public void updateContainerConfig(String serverTemplateId, String containerSpecId, Capability capability, ContainerConfig containerConfig) {
        this.service.updateContainerConfig(serverTemplateId, containerSpecId, capability, containerConfig);
    }

    public void startContainer(ContainerSpecKey containerSpecKey) {
        this.service.startContainer(containerSpecKey);
    }

    public void stopContainer(ContainerSpecKey containerSpecKey) {
        this.service.stopContainer(containerSpecKey);
    }

    public void activateContainer(ContainerSpecKey containerSpecKey) {
        this.service.activateContainer(containerSpecKey);
    }

    public void deactivateContainer(ContainerSpecKey containerSpecKey) {
        this.service.deactivateContainer(containerSpecKey);
    }
}

