/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.storage;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.openshift.storage.OpenShiftServerTemplateStorage;
import org.kie.workbench.common.screens.server.management.backend.utils.EmbeddedController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@EmbeddedController
public class ServerTemplateOCPStorage
implements KieServerTemplateStorage {
    private static final Logger logger = LoggerFactory.getLogger(ServerTemplateOCPStorage.class);
    private OpenShiftServerTemplateStorage instance = OpenShiftServerTemplateStorage.getInstance();

    @Inject
    public ServerTemplateOCPStorage() {
        logger.info("OpenShift server template storage initialized.");
    }

    public ServerTemplate store(ServerTemplate serverTemplate) {
        return this.instance.store(serverTemplate);
    }

    public List<ServerTemplateKey> loadKeys() {
        return this.instance.loadKeys();
    }

    public List<ServerTemplate> load() {
        return this.instance.load();
    }

    public ServerTemplate load(String identifier) {
        return this.instance.load(identifier);
    }

    public boolean exists(String identifier) {
        return this.instance.exists(identifier);
    }

    public ServerTemplate update(ServerTemplate serverTemplate) {
        return this.instance.update(serverTemplate);
    }

    public ServerTemplate delete(String identifier) {
        return this.instance.delete(identifier);
    }
}

