/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.service;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.websocket.notification.WebSocketNotificationService;
import org.kie.workbench.common.screens.server.management.backend.utils.EmbeddedController;
import org.kie.workbench.common.screens.server.management.model.ContainerSpecData;

@ApplicationScoped
@EmbeddedController
public class EmbeddedNotificationService
extends WebSocketNotificationService {
    @Inject
    private Event<ServerTemplateUpdated> serverTemplateUpdatedEvent;
    @Inject
    private Event<ServerTemplateDeleted> serverTemplateDeletedEvent;
    @Inject
    private Event<ServerInstanceUpdated> serverInstanceUpdatedEvent;
    @Inject
    private Event<ServerInstanceDeleted> serverInstanceDeletedEvent;
    @Inject
    private Event<ServerInstanceConnected> serverInstanceConnectedEvent;
    @Inject
    private Event<ServerInstanceDisconnected> serverInstanceDisconnectedEvent;
    @Inject
    private Event<ContainerSpecData> containerSpecDataEvent;

    public void notify(ServerTemplate serverTemplate, ContainerSpec containerSpec, List<Container> containers) {
        super.notify(serverTemplate, containerSpec, containers);
        ContainerSpecData containerSpecData = new ContainerSpecData(containerSpec, containers);
        this.containerSpecDataEvent.fire((Object)containerSpecData);
    }

    public void notify(ServerTemplateUpdated serverTemplateUpdated) {
        super.notify(serverTemplateUpdated);
        this.serverTemplateUpdatedEvent.fire((Object)serverTemplateUpdated);
    }

    public void notify(ServerTemplateDeleted serverTemplateDeleted) {
        super.notify(serverTemplateDeleted);
        this.serverTemplateDeletedEvent.fire((Object)serverTemplateDeleted);
    }

    public void notify(ServerInstanceUpdated serverInstanceUpdated) {
        super.notify(serverInstanceUpdated);
        this.serverInstanceUpdatedEvent.fire((Object)serverInstanceUpdated);
    }

    public void notify(ServerInstanceDeleted serverInstanceDeleted) {
        super.notify(serverInstanceDeleted);
        this.serverInstanceDeletedEvent.fire((Object)serverInstanceDeleted);
    }

    public void notify(ServerInstanceConnected serverInstanceConnected) {
        super.notify(serverInstanceConnected);
        this.serverInstanceConnectedEvent.fire((Object)serverInstanceConnected);
    }

    public void notify(ServerInstanceDisconnected serverInstanceDisconnected) {
        super.notify(serverInstanceDisconnected);
        this.serverInstanceDisconnectedEvent.fire((Object)serverInstanceDisconnected);
    }
}

