/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.service.RuntimeManagementServiceImpl;
import org.kie.workbench.common.screens.server.management.model.ContainerSpecData;
import org.kie.workbench.common.screens.server.management.service.RuntimeManagementService;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;

@Service
@ApplicationScoped
public class RuntimeManagementServiceCDI
extends RuntimeManagementServiceImpl
implements RuntimeManagementService {
    @Inject
    private SpecManagementService specManagementService;

    @Inject
    public void setKieServerInstanceManager(KieServerInstanceManager kieServerInstanceManager) {
        super.setKieServerInstanceManager(kieServerInstanceManager);
    }

    @Inject
    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        super.setTemplateStorage(templateStorage);
    }

    public Collection<Container> getContainersByServerInstance(String serverTemplateId, String serverInstanceId) {
        ServerTemplate serverTemplate = this.getTemplateStorage().load(serverTemplateId);
        if (serverTemplate == null) {
            throw new RuntimeException("No server template found for server instance id " + serverInstanceId);
        }
        for (ServerInstanceKey serverInstance : serverTemplate.getServerInstanceKeys()) {
            if (!serverInstance.getServerInstanceId().equals(serverInstanceId)) continue;
            return this.getContainers(serverInstance);
        }
        return Collections.emptyList();
    }

    public ContainerSpecData getContainersByContainerSpec(String serverTemplateId, String containerSpecId) {
        ArrayList containers = new ArrayList();
        ServerTemplate serverTemplate = this.getTemplateStorage().load(serverTemplateId);
        if (serverTemplate == null) {
            throw new RuntimeException("No server template found for container spec " + containerSpecId);
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecId);
        this.getKieServerInstanceManager().getContainers(serverTemplate, containerSpec);
        return new ContainerSpecData(serverTemplate.getContainerSpec(containerSpecId), containers);
    }
}

