/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.service;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.rest.RestSpecManagementServiceImpl;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.commons.validation.PortablePreconditions;

@Service
@ApplicationScoped
public class SpecManagementServiceCDI
extends RestSpecManagementServiceImpl
implements SpecManagementService {
    @Inject
    public void setKieServerInstanceManager(KieServerInstanceManager kieServerInstanceManager) {
        super.setKieServerInstanceManager(kieServerInstanceManager);
    }

    @Inject
    public void setNotificationService(NotificationService notificationService) {
        super.setNotificationService(notificationService);
    }

    @Inject
    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        super.setTemplateStorage(templateStorage);
    }

    public void deleteServerInstance(ServerInstanceKey serverInstanceKey) {
        PortablePreconditions.checkNotNull((String)"serverInstanceKey", (Object)serverInstanceKey);
        if (this.getKieServerInstanceManager().isAlive(serverInstanceKey)) {
            throw new RuntimeException("Can't delete live instance.");
        }
        String serverInstanceId = serverInstanceKey.getServerInstanceId();
        ServerTemplate serverTemplate = this.getServerTemplate(serverInstanceKey.getServerTemplateId());
        if (serverTemplate != null) {
            serverTemplate.deleteServerInstance(serverInstanceId);
            this.getTemplateStorage().update(serverTemplate);
            this.getNotificationService().notify(new ServerInstanceDeleted(serverInstanceId));
        }
    }

    public boolean isContainerIdValid(String serverTemplateId, String containerId) {
        if (!this.isValidIdentifier(containerId)) {
            return false;
        }
        ServerTemplate template = this.getServerTemplate(serverTemplateId);
        if (template == null) {
            throw new RuntimeException("Server template doesn't exists");
        }
        return template.getContainerSpec(containerId) == null;
    }

    public String validContainerId(String serverTemplateId, String containerId) {
        if (this.isContainerIdValid(serverTemplateId, containerId)) {
            return containerId;
        }
        return this.validContainerIdWithSuffix(serverTemplateId, containerId);
    }

    public boolean isNewServerTemplateIdValid(String serverTemplateId) {
        return !this.getTemplateStorage().exists(serverTemplateId);
    }

    private String validContainerIdWithSuffix(String serverTemplateId, String containerId) {
        int attemptNumber = 2;
        while (!this.isContainerIdValid(serverTemplateId, containerId + "-" + attemptNumber)) {
            ++attemptNumber;
        }
        return containerId + "-" + attemptNumber;
    }

    private boolean isValidIdentifier(String identifier) {
        return identifier != null && identifier.matches("[A-Za-z0-9_\\-.:]+");
    }
}

