/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.workbench.common.screens.server.management.backend.utils.EmbeddedController;
import org.kie.workbench.common.screens.server.management.model.ContainerRuntimeOperation;
import org.kie.workbench.common.screens.server.management.model.ContainerRuntimeState;
import org.kie.workbench.common.screens.server.management.model.ContainerUpdateEvent;
import org.uberfire.commons.concurrent.Managed;

@ApplicationScoped
@EmbeddedController
public class AsyncKieServerInstanceManager
extends KieServerInstanceManager {
    private ExecutorService executor;
    private NotificationService notificationService;
    private Event<ContainerUpdateEvent> containerUpdateEvent;

    protected void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Inject
    public AsyncKieServerInstanceManager(@EmbeddedController NotificationService notificationService, Event<ContainerUpdateEvent> containerUpdateEvent, @Managed ExecutorService executorService) {
        this.notificationService = notificationService;
        this.containerUpdateEvent = containerUpdateEvent;
        this.executor = executorService;
    }

    public List<Container> startScanner(final ServerTemplate serverTemplate, final ContainerSpec containerSpec, final long interval) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.startScanner(serverTemplate, containerSpec, interval);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
                AsyncKieServerInstanceManager.this.produceContainerUpdateEvent(serverTemplate, containerSpec, containers, ContainerRuntimeOperation.START_SCANNER);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> stopScanner(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.stopScanner(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
                AsyncKieServerInstanceManager.this.produceContainerUpdateEvent(serverTemplate, containerSpec, containers, ContainerRuntimeOperation.STOP_SCANNER);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> scanNow(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.scanNow(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
                AsyncKieServerInstanceManager.this.produceContainerUpdateEvent(serverTemplate, containerSpec, containers, ContainerRuntimeOperation.SCAN);
            }
        });
        return Collections.emptyList();
    }

    public synchronized List<Container> startContainer(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.startContainer(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
                AsyncKieServerInstanceManager.this.produceContainerUpdateEvent(serverTemplate, containerSpec, containers, ContainerRuntimeOperation.START_CONTAINER);
            }
        });
        return Collections.emptyList();
    }

    public synchronized List<Container> stopContainer(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.stopContainer(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
                AsyncKieServerInstanceManager.this.produceContainerUpdateEvent(serverTemplate, containerSpec, containers, ContainerRuntimeOperation.STOP_CONTAINER);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> upgradeContainer(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.upgradeContainer(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
                AsyncKieServerInstanceManager.this.produceContainerUpdateEvent(serverTemplate, containerSpec, containers, ContainerRuntimeOperation.UPGRADE_CONTAINER);
            }
        });
        return Collections.emptyList();
    }

    public List<Container> getContainers(final ServerInstanceKey serverInstanceKey) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.getContainers(serverInstanceKey);
                ServerInstance serverInstance = new ServerInstance();
                serverInstance.setServerName(serverInstanceKey.getServerName());
                serverInstance.setServerTemplateId(serverInstanceKey.getServerTemplateId());
                serverInstance.setServerInstanceId(serverInstanceKey.getServerInstanceId());
                serverInstance.setUrl(serverInstanceKey.getUrl());
                serverInstance.setContainers((Collection)containers);
                AsyncKieServerInstanceManager.this.notificationService.notify(new ServerInstanceUpdated(serverInstance));
            }
        });
        return Collections.emptyList();
    }

    public List<Container> getContainers(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List containers = AsyncKieServerInstanceManager.super.getContainers(serverTemplate, containerSpec);
                AsyncKieServerInstanceManager.this.notificationService.notify(serverTemplate, containerSpec, containers);
            }
        });
        return Collections.emptyList();
    }

    protected void produceContainerUpdateEvent(ServerTemplate serverTemplate, ContainerSpec containerSpec, List<Container> containers, ContainerRuntimeOperation containerRuntimeOperation) {
        ArrayList<ServerInstanceKey> failedServerInstances = new ArrayList<ServerInstanceKey>();
        for (Container container : containers) {
            if (!this.hasIssues(container)) continue;
            failedServerInstances.add(container.getServerInstanceKey());
        }
        ContainerRuntimeState containerRuntimeState = ContainerRuntimeState.ONLINE;
        if (failedServerInstances.size() == containers.size()) {
            containerRuntimeState = ContainerRuntimeState.OFFLINE;
        } else if (!failedServerInstances.isEmpty()) {
            containerRuntimeState = ContainerRuntimeState.PARTIAL_ONLINE;
        }
        ContainerUpdateEvent updateEvent = new ContainerUpdateEvent((ServerTemplateKey)serverTemplate, containerSpec, failedServerInstances, containerRuntimeState, containerRuntimeOperation);
        this.containerUpdateEvent.fire((Object)updateEvent);
    }

    protected boolean hasIssues(Container container) {
        if (container.getStatus().equals((Object)KieContainerStatus.FAILED)) {
            return true;
        }
        if (container.getMessages() != null) {
            for (Message message : container.getMessages()) {
                if (!message.getSeverity().equals((Object)Severity.ERROR) && !message.getSeverity().equals((Object)Severity.WARN)) continue;
                return true;
            }
        }
        return false;
    }
}

