/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.exceptions.ExceptionUtilities;
import org.kie.workbench.common.services.builder.Builder;
import org.kie.workbench.common.services.builder.LRUBuilderCache;
import org.kie.workbench.common.services.project.service.POMService;
import org.kie.workbench.common.services.project.service.ProjectService;
import org.kie.workbench.common.services.project.service.model.POM;
import org.kie.workbench.common.services.shared.builder.BuildService;
import org.kie.workbench.common.services.shared.builder.model.BuildResults;
import org.kie.workbench.common.services.shared.builder.model.DeployResult;
import org.kie.workbench.common.services.shared.builder.model.IncrementalBuildResults;
import org.kie.workbench.common.services.shared.context.Project;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@Service
@ApplicationScoped
public class BuildServiceImpl
implements BuildService {
    private Paths paths;
    private Event<BuildResults> buildResultsEvent;
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;
    private POMService pomService;
    private ExtendedM2RepoService m2RepoService;
    private ProjectService projectService;
    private LRUBuilderCache cache;
    private Event<DeployResult> deployResultEvent;

    public BuildServiceImpl() {
    }

    @Inject
    public BuildServiceImpl(Paths paths, POMService pomService, ExtendedM2RepoService m2RepoService, Event<BuildResults> buildResultsEvent, Event<IncrementalBuildResults> incrementalBuildResultsEvent, ProjectService projectService, LRUBuilderCache cache, Event<DeployResult> deployResultEvent) {
        this.paths = paths;
        this.pomService = pomService;
        this.m2RepoService = m2RepoService;
        this.buildResultsEvent = buildResultsEvent;
        this.incrementalBuildResultsEvent = incrementalBuildResultsEvent;
        this.projectService = projectService;
        this.cache = cache;
        this.deployResultEvent = deployResultEvent;
    }

    public void build(Project project) {
        try {
            BuildResults results = this.doBuild(project);
            this.buildResultsEvent.fire((Object)results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void buildAndDeploy(Project project) {
        try {
            BuildResults results = this.doBuild(project);
            this.buildResultsEvent.fire((Object)results);
            if (results.getMessages().isEmpty()) {
                Builder builder = this.cache.assertBuilder(project);
                POM pom = (POM)this.pomService.load(project.getPomXMLPath());
                InternalKieModule kieModule = (InternalKieModule)builder.getKieModule();
                ByteArrayInputStream input = new ByteArrayInputStream(kieModule.getBytes());
                this.m2RepoService.deployJar((InputStream)input, pom.getGav());
                this.deployResultEvent.fire((Object)new DeployResult(pom.getGav().getGroupId(), pom.getGav().getArtifactId(), pom.getGav().getVersion()));
            }
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private BuildResults doBuild(Project project) {
        Builder builder = this.cache.assertBuilder(project);
        BuildResults results = builder.build();
        return results;
    }

    public void addPackageResource(Path resource) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
            IncrementalBuildResults results = builder.addResource(this.paths.convert(resource));
            this.incrementalBuildResultsEvent.fire((Object)results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void deletePackageResource(Path resource) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
            IncrementalBuildResults results = builder.deleteResource(this.paths.convert(resource));
            this.incrementalBuildResultsEvent.fire((Object)results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void updatePackageResource(Path resource) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
            IncrementalBuildResults results = builder.updateResource(this.paths.convert(resource));
            this.incrementalBuildResultsEvent.fire((Object)results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void updateProjectResource(Path resource) {
        try {
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void applyBatchResourceChanges(Project project, Set<ResourceChange> changes) {
        try {
            if (project == null) {
                return;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                this.build(project);
            }
            IncrementalBuildResults results = builder.applyBatchResourceChanges(changes);
            this.incrementalBuildResultsEvent.fire((Object)results);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

