/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.builder;

import javax.inject.Inject;
import org.guvnor.m2repo.service.M2RepoService;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.workbench.common.services.backend.session.SessionService;
import org.kie.workbench.common.services.builder.Builder;
import org.kie.workbench.common.services.builder.LRUBuilderCache;
import org.kie.workbench.common.services.shared.context.Project;
import org.kie.workbench.common.services.shared.exceptions.GenericPortableException;

public class SessionServiceImpl
implements SessionService {
    private LRUBuilderCache cache;
    private M2RepoService m2RepoService;

    public SessionServiceImpl() {
    }

    @Inject
    public SessionServiceImpl(LRUBuilderCache cache, M2RepoService m2RepoService) {
        this.cache = cache;
        this.m2RepoService = m2RepoService;
    }

    public KieSession newKieSession(Project project, String sessionName) {
        Builder builder = this.cache.assertBuilder(project);
        KieContainer kieContainer = null;
        try {
            kieContainer = builder.getKieContainer();
        }
        catch (RuntimeException e) {
            throw new GenericPortableException(e.getMessage());
        }
        return kieContainer.newKieSession(sessionName);
    }
}

