/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.kie.workbench.common.services.backend.compiler.HttpCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultHttpCompilationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    protected static Logger logger = LoggerFactory.getLogger(RestUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpCompilationResponse readDefaultCompilationResponseFromBytes(byte[] bytes) {
        ObjectInputStream in = null;
        ByteArrayOutputStream bos = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object newObj = in.readObject();
            HttpCompilationResponse httpCompilationResponse = (HttpCompilationResponse)newObj;
            return httpCompilationResponse;
        }
        catch (NotSerializableException nse) {
            logger.warn("Object is not serializable {}", (Object)nse.getMessage());
            StringBuilder sb = new StringBuilder("NotSerializableException:").append(nse.getMessage());
            logger.error(sb.toString());
        }
        catch (IOException ioe) {
            StringBuilder sb = new StringBuilder("IOException:").append(ioe.getMessage());
            logger.error(sb.toString());
        }
        catch (ClassNotFoundException cnfe) {
            StringBuilder sb = new StringBuilder("ClassNotFoundException:").append(cnfe.getMessage());
            logger.error(sb.toString());
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Exception:").append(e.getMessage());
            logger.error(sb.toString());
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
        }
        return new DefaultHttpCompilationResponse(Boolean.FALSE);
    }

    public static byte[] serialize(Object obj) {
        byte[] returnArray = null;
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(obj);
            }
            returnArray = b.toByteArray();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
        return returnArray;
    }
}

