/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.rest.server;

import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultHttpCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.rest.RestUtils;
import org.kie.workbench.common.services.backend.compiler.service.AFCompilerService;
import org.kie.workbench.common.services.backend.compiler.service.DefaultKieCompilerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/build/maven/")
@RequestScoped
public class MavenRestHandler
extends Application {
    private static Logger logger = LoggerFactory.getLogger(MavenRestHandler.class);
    private static String maven = "Apache Maven";
    private AFCompilerService compilerService = new DefaultKieCompilerService();

    @GET
    @Produces(value={"text/plain"})
    public String get() {
        return maven;
    }

    @POST
    @Produces(value={"application/octet-stream"})
    public void postAsync(@Suspended AsyncResponse ar, @HeaderParam(value="project") String projectRepo, @HeaderParam(value="mavenrepo") String mavenRepoPath, @HeaderParam(value="settings_xml") String settingsXmlPath) throws Exception {
        CompletableFuture response = this.compilerService.build(projectRepo, mavenRepoPath, settingsXmlPath);
        response.whenCompleteAsync((kieCompilationResponse, throwable) -> {
            if (throwable != null) {
                logger.error(throwable.getMessage());
                ar.resume((Object)Response.serverError().build());
            } else {
                byte[] bytes = RestUtils.serialize((Object)new DefaultHttpCompilationResponse(kieCompilationResponse));
                ar.resume((Object)Response.ok((Object)bytes).build());
            }
        });
    }
}

