/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.service.executors;

import java.io.InputStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.kie.workbench.common.services.backend.compiler.AFCompiler;
import org.kie.workbench.common.services.backend.compiler.CompilationRequest;
import org.kie.workbench.common.services.backend.compiler.configuration.KieDecorator;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.impl.WorkspaceCompilationInfo;
import org.kie.workbench.common.services.backend.compiler.impl.kie.KieCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.impl.kie.KieMavenCompilerFactory;
import org.kie.workbench.common.services.backend.compiler.service.executors.CompilerAggregateEntryCache;
import org.kie.workbench.common.services.backend.compiler.service.executors.CompilerExecutor;
import org.uberfire.java.nio.file.Path;

public class DefaultLocalExecutor
implements CompilerExecutor {
    private ExecutorService executor;
    private LRUCache<Path, CompilerAggregateEntryCache> compilerCacheForLocalInvocation;

    public DefaultLocalExecutor(ExecutorService executorService) {
        this.executor = executorService;
        this.compilerCacheForLocalInvocation = new LRUCache<Path, CompilerAggregateEntryCache>(){};
    }

    private AFCompiler getCompiler(Path projectPath) {
        CompilerAggregateEntryCache info = (CompilerAggregateEntryCache)this.compilerCacheForLocalInvocation.getEntry((Object)projectPath);
        if (info != null && info.getCompiler() != null) {
            return info.getCompiler();
        }
        return this.getNewCachedAFCompiler(projectPath);
    }

    private CompilationRequest getDefaultRequest(String mavenRepoPath, WorkspaceCompilationInfo info, boolean skipProjectDepCreation, String[] goals) {
        return new DefaultCompilationRequest(mavenRepoPath, info, goals, Boolean.valueOf(skipProjectDepCreation));
    }

    private AFCompiler getNewCachedAFCompiler(Path projectPath) {
        CompilerAggregateEntryCache info = this.setupCompileInfo(projectPath);
        this.compilerCacheForLocalInvocation.setEntry((Object)projectPath, (Object)info);
        return info.getCompiler();
    }

    private CompilerAggregateEntryCache setupCompileInfo(Path workingDir) {
        AFCompiler compiler = KieMavenCompilerFactory.getCompiler(EnumSet.of(KieDecorator.ENABLE_LOGGING, KieDecorator.UPDATE_JGIT_BEFORE_BUILD, KieDecorator.STORE_KIE_OBJECTS, KieDecorator.STORE_BUILD_CLASSPATH, KieDecorator.ENABLE_INCREMENTAL_BUILD));
        WorkspaceCompilationInfo info = new WorkspaceCompilationInfo(workingDir);
        return new CompilerAggregateEntryCache(compiler, info);
    }

    private CompletableFuture<KieCompilationResponse> internalBuild(Path projectPath, String mavenRepoPath, String settingXML, boolean skipProjectDepCreation, String goal) {
        WorkspaceCompilationInfo info = new WorkspaceCompilationInfo(projectPath);
        AFCompiler compiler = this.getCompiler(projectPath);
        CompilationRequest req = settingXML != null ? this.getDefaultRequest(mavenRepoPath, info, skipProjectDepCreation, new String[]{"-s" + settingXML, goal}) : this.getDefaultRequest(mavenRepoPath, info, skipProjectDepCreation, new String[]{goal});
        return CompletableFuture.supplyAsync(() -> (KieCompilationResponse)compiler.compile(req), this.executor);
    }

    private CompletableFuture<KieCompilationResponse> internalBuild(Path projectPath, String mavenRepoPath, boolean skipProjectDepCreation, String[] args) {
        WorkspaceCompilationInfo info = new WorkspaceCompilationInfo(projectPath);
        AFCompiler compiler = this.getCompiler(projectPath);
        CompilationRequest req = this.getDefaultRequest(mavenRepoPath, info, skipProjectDepCreation, args);
        return CompletableFuture.supplyAsync(() -> (KieCompilationResponse)compiler.compile(req), this.executor);
    }

    private CompletableFuture<KieCompilationResponse> internalBuild(Path projectPath, String mavenRepoPath, String settingXML, boolean skipProjectDepCreation, String goal, Map<Path, InputStream> override) {
        WorkspaceCompilationInfo info = new WorkspaceCompilationInfo(projectPath);
        AFCompiler compiler = this.getCompiler(projectPath);
        CompilationRequest req = settingXML != null ? this.getDefaultRequest(mavenRepoPath, info, skipProjectDepCreation, new String[]{"-s" + settingXML, goal}) : this.getDefaultRequest(mavenRepoPath, info, skipProjectDepCreation, new String[]{goal});
        return CompletableFuture.supplyAsync(() -> (KieCompilationResponse)compiler.compile(req, override), this.executor);
    }

    @Override
    public CompletableFuture<KieCompilationResponse> build(Path projectPath, String mavenRepoPath, String settingXML) {
        return this.internalBuild(projectPath, mavenRepoPath, settingXML, Boolean.FALSE, "compile");
    }

    @Override
    public CompletableFuture<KieCompilationResponse> build(Path projectPath, String mavenRepoPath, String settingXML, Map<Path, InputStream> override) {
        return this.internalBuild(projectPath, mavenRepoPath, settingXML, Boolean.FALSE, "compile", override);
    }

    @Override
    public CompletableFuture<KieCompilationResponse> build(Path projectPath, String mavenRepoPath, String settingXML, Boolean skipPrjDependenciesCreationList) {
        return this.internalBuild(projectPath, mavenRepoPath, settingXML, skipPrjDependenciesCreationList, "compile");
    }

    @Override
    public CompletableFuture<KieCompilationResponse> buildAndInstall(Path projectPath, String mavenRepoPath, String settingXML) {
        return this.internalBuild(projectPath, mavenRepoPath, settingXML, Boolean.FALSE, "install");
    }

    @Override
    public CompletableFuture<KieCompilationResponse> buildAndInstall(Path projectPath, String mavenRepoPath, String settingXML, Boolean skipPrjDependenciesCreationList) {
        return this.internalBuild(projectPath, mavenRepoPath, settingXML, skipPrjDependenciesCreationList, "install");
    }

    @Override
    public CompletableFuture<KieCompilationResponse> buildSpecialized(Path projectPath, String mavenRepoPath, String[] args) {
        return this.internalBuild(projectPath, mavenRepoPath, Boolean.FALSE, args);
    }

    @Override
    public CompletableFuture<KieCompilationResponse> buildSpecialized(Path projectPath, String mavenRepoPath, String[] args, Boolean skipPrjDependenciesCreationList) {
        return this.internalBuild(projectPath, mavenRepoPath, skipPrjDependenciesCreationList, args);
    }
}

