/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.service.executors;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.kie.workbench.common.services.backend.compiler.AFCompiler;
import org.kie.workbench.common.services.backend.compiler.CompilationRequest;
import org.kie.workbench.common.services.backend.compiler.impl.BaseMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.impl.WorkspaceCompilationInfo;
import org.kie.workbench.common.services.backend.compiler.impl.decorators.ClasspathDepsAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.impl.decorators.KieAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.impl.decorators.OutputLogAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.impl.kie.KieCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.service.executors.CompilerAggregateEntryCache;
import org.kie.workbench.common.services.backend.compiler.service.executors.RemoteExecutor;
import org.uberfire.java.nio.file.Paths;

public class DefaultRemoteExecutor
implements RemoteExecutor {
    private ExecutorService executor;
    private LRUCache<String, CompilerAggregateEntryCache> compilerCacheForRemoteInvocation;

    public DefaultRemoteExecutor(ExecutorService executorService) {
        this.executor = executorService;
        this.compilerCacheForRemoteInvocation = new LRUCache<String, CompilerAggregateEntryCache>(){};
    }

    private AFCompiler getCompiler(String projectPath) {
        CompilerAggregateEntryCache info = (CompilerAggregateEntryCache)this.compilerCacheForRemoteInvocation.getEntry((Object)projectPath);
        if (info != null && info.getCompiler() != null) {
            return info.getCompiler();
        }
        return this.getNewCachedAFCompiler(projectPath);
    }

    private AFCompiler getNewCachedAFCompiler(String projectPath) {
        CompilerAggregateEntryCache info = this.setupCompileInfo(projectPath);
        this.compilerCacheForRemoteInvocation.setEntry((Object)projectPath, (Object)info);
        return info.getCompiler();
    }

    private CompilerAggregateEntryCache setupCompileInfo(String workingDir) {
        KieAfterDecorator compiler = new KieAfterDecorator((AFCompiler)new OutputLogAfterDecorator((AFCompiler)new ClasspathDepsAfterDecorator((AFCompiler)new BaseMavenCompiler(true, true))));
        WorkspaceCompilationInfo info = new WorkspaceCompilationInfo(Paths.get((String)workingDir, (String[])new String[0]));
        return new CompilerAggregateEntryCache((AFCompiler)compiler, info);
    }

    private CompletableFuture<KieCompilationResponse> internalBuild(String projectPath, String mavenRepoPath, String settingsXmlPath, boolean skipProjectDepCreation, String goal) {
        WorkspaceCompilationInfo info = new WorkspaceCompilationInfo(Paths.get((String)projectPath, (String[])new String[0]));
        AFCompiler compiler = this.getCompiler(projectPath);
        DefaultCompilationRequest req = settingsXmlPath != null ? new DefaultCompilationRequest(mavenRepoPath, info, new String[]{"-s" + settingsXmlPath, goal}, Boolean.valueOf(skipProjectDepCreation)) : new DefaultCompilationRequest(mavenRepoPath, info, new String[]{goal}, Boolean.valueOf(skipProjectDepCreation));
        return this.runInItsOwnThread(compiler, (CompilationRequest)req);
    }

    private CompletableFuture<KieCompilationResponse> internalBuild(String projectPath, String mavenRepoPath, boolean skipProjectDepCreation, String[] args) {
        WorkspaceCompilationInfo info = new WorkspaceCompilationInfo(Paths.get((String)projectPath, (String[])new String[0]));
        AFCompiler compiler = this.getCompiler(projectPath);
        DefaultCompilationRequest req = new DefaultCompilationRequest(mavenRepoPath, info, args, Boolean.valueOf(skipProjectDepCreation));
        return this.runInItsOwnThread(compiler, (CompilationRequest)req);
    }

    private CompletableFuture<KieCompilationResponse> runInItsOwnThread(AFCompiler compiler, CompilationRequest req) {
        return CompletableFuture.supplyAsync(() -> (KieCompilationResponse)compiler.compile(req), this.executor);
    }

    @Override
    public CompletableFuture<KieCompilationResponse> build(String projectPath, String mavenRepoPath, String settingsXmlPath) {
        return this.internalBuild(projectPath, mavenRepoPath, settingsXmlPath, Boolean.FALSE, "compile");
    }

    @Override
    public CompletableFuture<KieCompilationResponse> build(String projectPath, String mavenRepoPath, String settingsXmlPath, Boolean skipPrjDependenciesCreationList) {
        return this.internalBuild(projectPath, mavenRepoPath, settingsXmlPath, skipPrjDependenciesCreationList, "compile");
    }

    @Override
    public CompletableFuture<KieCompilationResponse> buildAndInstall(String projectPath, String mavenRepoPath, String settingsXmlPath) {
        return this.internalBuild(projectPath, mavenRepoPath, settingsXmlPath, Boolean.FALSE, "install");
    }

    @Override
    public CompletableFuture<KieCompilationResponse> buildAndInstall(String projectPath, String mavenRepoPath, String settingsXmlPath, Boolean skipPrjDependenciesCreationList) {
        return this.internalBuild(projectPath, mavenRepoPath, settingsXmlPath, skipPrjDependenciesCreationList, "install");
    }

    @Override
    public CompletableFuture<KieCompilationResponse> buildSpecialized(String projectPath, String mavenRepoPath, String[] args) {
        return this.internalBuild(projectPath, mavenRepoPath, Boolean.FALSE, args);
    }

    @Override
    public CompletableFuture<KieCompilationResponse> buildSpecialized(String projectPath, String mavenRepoPath, String[] args, Boolean skipPrjDependenciesCreationList) {
        return this.internalBuild(projectPath, mavenRepoPath, skipPrjDependenciesCreationList, args);
    }
}

