/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.services.datamodel.model;

import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public enum FieldAccessorsAndMutators {

    MUTATOR,
    ACCESSOR,
    BOTH;

    public static boolean compare( final FieldAccessorsAndMutators field1,
                                   final FieldAccessorsAndMutators field2 ) {

        if ( field1 == field2 ) {
            return true;
        } else if ( field1 == BOTH || field2 == BOTH ) {
            return true;
        } else {
            return false;
        }
    }

}
