/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.file;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.workbench.common.services.shared.file.CopyService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceCopiedEvent;

@Service
public class CopyServiceImpl
implements CopyService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;
    @Inject
    private Event<ResourceCopiedEvent> resourceCopiedEvent;

    public Path copy(Path path, String newName, String comment) {
        System.out.println("USER:" + this.identity.getName() + " COPYING asset [" + path.getFileName() + "] to [" + newName + "]");
        String originalFileName = path.getFileName().substring(path.getFileName().lastIndexOf("/") + 1);
        String extension = originalFileName.substring(originalFileName.indexOf("."));
        String targetName = path.getFileName().substring(0, path.getFileName().lastIndexOf("/") + 1) + newName + extension;
        String targetURI = path.toURI().substring(0, path.toURI().lastIndexOf("/") + 1) + newName + extension;
        Path targetPath = PathFactory.newPath((FileSystem)path.getFileSystem(), (String)targetName, (String)targetURI);
        this.ioService.copy(this.paths.convert(path), this.paths.convert(targetPath), new CopyOption[]{new CommentedOption(this.identity.getName(), comment)});
        this.resourceCopiedEvent.fire((Object)new ResourceCopiedEvent(path, targetPath));
        return targetPath;
    }
}

