/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.file;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.file.FileDiscoveryService;

@ApplicationScoped
public class FileDiscoveryServiceImpl
implements FileDiscoveryService {
    @Override
    public Collection<Path> discoverFiles(Path pathToSearch, DirectoryStream.Filter<Path> filter, boolean recursive) {
        PortablePreconditions.checkNotNull((String)"pathToSearch", (Object)pathToSearch);
        PortablePreconditions.checkNotNull((String)"filter", filter);
        ArrayList<Path> discoveredFiles = new ArrayList<Path>();
        if (Files.isRegularFile((Path)pathToSearch, (LinkOption[])new LinkOption[0]) && filter.accept((Object)pathToSearch)) {
            discoveredFiles.add(pathToSearch);
            return discoveredFiles;
        }
        if (!Files.isDirectory((Path)pathToSearch, (LinkOption[])new LinkOption[0])) {
            return discoveredFiles;
        }
        DirectoryStream paths = Files.newDirectoryStream((Path)pathToSearch);
        for (Path path : paths) {
            if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
                if (!filter.accept((Object)path)) continue;
                discoveredFiles.add(path);
                continue;
            }
            if (!recursive || !Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) continue;
            discoveredFiles.addAll(this.discoverFiles(path, filter, recursive));
        }
        return discoveredFiles;
    }

    @Override
    public Collection<Path> discoverFiles(Path pathToSearch, DirectoryStream.Filter<Path> filter) {
        return this.discoverFiles(pathToSearch, filter, false);
    }
}

