/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.file;

import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.file.DotFileFilter;

public class FileExtensionFilter
extends DotFileFilter {
    private String extension;

    public FileExtensionFilter(String extension) {
        this.extension = (String)PortablePreconditions.checkNotNull((String)"extension", (Object)extension);
        if (!extension.startsWith(".")) {
            this.extension = "." + extension;
        }
    }

    @Override
    public boolean accept(Path path) {
        boolean accept = super.accept(path);
        if (!accept) {
            return accept;
        }
        if (!Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
            return false;
        }
        String uri = path.toUri().toString();
        return uri.substring(uri.length() - this.extension.length()).equals(this.extension);
    }
}

