/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.file;

import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.file.DotFileFilter;

public class FileExtensionsFilter
extends DotFileFilter {
    private String[] extensions;

    public FileExtensionsFilter(String[] extensions) {
        this.extensions = (String[])PortablePreconditions.checkNotNull((String)"extension", (Object)extensions);
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i].startsWith(".")) continue;
            extensions[i] = "." + extensions[i];
        }
    }

    @Override
    public boolean accept(Path path) {
        boolean accept = super.accept(path);
        if (!accept) {
            return accept;
        }
        if (!Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
            return false;
        }
        accept = false;
        String uri = path.toUri().toString();
        for (String extension : this.extensions) {
            if (!uri.substring(uri.length() - extension.length()).equals(extension)) continue;
            accept = true;
            break;
        }
        return accept;
    }
}

