/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.file.upload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.drools.core.util.DateUtils;
import org.kie.workbench.common.services.backend.file.upload.FormData;
import org.kie.workbench.common.services.shared.file.upload.FileOperation;
import org.uberfire.backend.vfs.Path;

public abstract class AbstractFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 510L;

    protected abstract InputStream doLoad(Path var1);

    protected abstract void doCreate(Path var1, InputStream var2, String var3);

    protected abstract void doUpdate(Path var1, InputStream var2, String var3);

    protected abstract Path convertPath(String var1, String var2) throws URISyntaxException;

    protected abstract Path convertPath(String var1) throws URISyntaxException;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        FormData item = this.getFormData(request);
        if (item.getFile() != null) {
            response.getWriter().write(this.processUpload(item));
            return;
        }
        response.getWriter().write("NO-SCRIPT-DATA");
    }

    private FormData getFormData(HttpServletRequest request) throws IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        FormData data = new FormData();
        try {
            List items = upload.parseRequest(request);
            Iterator it = items.iterator();
            FileOperation operation = null;
            String fileName = null;
            String contextPath = null;
            String fullPath = null;
            while (it.hasNext()) {
                FileItem item = (FileItem)it.next();
                if (!item.isFormField()) {
                    data.setFile(item);
                    continue;
                }
                if (item.getFieldName().equals("attachmentPath")) {
                    System.out.println("path:" + item.getString());
                    contextPath = item.getString();
                    continue;
                }
                if (item.getFieldName().equals("fileName")) {
                    System.out.println("name:" + item.getString());
                    fileName = item.getString();
                    continue;
                }
                if (item.getFieldName().equals("attachmentFullPath")) {
                    System.out.println("full path:" + item.getString());
                    fullPath = item.getString();
                    continue;
                }
                if (!item.getFieldName().equals("operation")) continue;
                System.out.println("operation:" + item.getString());
                operation = FileOperation.valueOf((String)item.getString());
            }
            if (operation == null) {
                throw new IllegalArgumentException("FORM_FIELD_OPERATION is null. Cannot process upload.");
            }
            switch (operation) {
                case CREATE: {
                    if (fileName == null) {
                        throw new IllegalArgumentException("FORM_FIELD_NAME is null. Cannot process upload.");
                    }
                    if (contextPath == null) {
                        throw new IllegalArgumentException("FORM_FIELD_PATH is null. Cannot process upload.");
                    }
                    data.setOperation(operation);
                    data.setTargetPath(this.convertPath(fileName, contextPath));
                    break;
                }
                case UPDATE: {
                    if (fullPath == null) {
                        throw new IllegalArgumentException("FORM_FIELD_FULL_PATH is null. Cannot process upload.");
                    }
                    data.setOperation(operation);
                    data.setTargetPath(this.convertPath(fullPath));
                }
            }
            return data;
        }
        catch (Exception e) {
            throw new org.kie.commons.java.nio.IOException(e.getMessage());
        }
    }

    private String processUpload(FormData item) throws IOException {
        if ("".equals(item.getFile().getName())) {
            throw new IOException("No file selected.");
        }
        String processResult = this.uploadFile(item);
        return processResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String uploadFile(FormData item) throws IOException {
        InputStream fileData = item.getFile().getInputStream();
        Path targetPath = item.getTargetPath();
        try {
            switch (item.getOperation()) {
                case CREATE: {
                    this.doCreate(targetPath, fileData, "Uploaded " + this.getTimestamp());
                    return "OK";
                }
                case UPDATE: {
                    this.doUpdate(targetPath, fileData, "Uploaded " + this.getTimestamp());
                    return "OK";
                }
            }
            return "OK";
        }
        finally {
            item.getFile().getInputStream().close();
        }
    }

    private String getTimestamp() {
        Calendar now = Calendar.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append(DateUtils.format((Date)now.getTime()));
        sb.append(" ");
        sb.append(now.get(11));
        sb.append(":");
        sb.append(now.get(12));
        sb.append(":");
        sb.append(now.get(13));
        return sb.toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getParameter("attachmentPath");
        if (path != null) {
            this.processAttachmentDownload(path, res);
        } else {
            res.sendError(400);
        }
    }

    protected void processAttachmentDownload(String path, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Path sourcePath = this.convertPath(path);
            IOUtils.copy((InputStream)this.doLoad(sourcePath), (OutputStream)output);
            String fileName = sourcePath.getFileName();
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ";");
            response.setContentLength(output.size());
            response.getOutputStream().write(output.toByteArray());
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            throw new org.kie.commons.java.nio.IOException(e.getMessage());
        }
    }
}

