/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.io.attribute.DublinCoreAttributes;
import org.kie.commons.io.attribute.DublinCoreAttributesUtil;
import org.kie.commons.io.attribute.DublinCoreView;
import org.kie.commons.java.nio.base.version.VersionAttributeView;
import org.kie.commons.java.nio.base.version.VersionRecord;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileTime;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.metadata.MetadataBuilder;
import org.kie.workbench.common.services.backend.metadata.attribute.DiscussionAttributes;
import org.kie.workbench.common.services.backend.metadata.attribute.DiscussionAttributesUtil;
import org.kie.workbench.common.services.backend.metadata.attribute.DiscussionView;
import org.kie.workbench.common.services.backend.metadata.attribute.OtherMetaAttributes;
import org.kie.workbench.common.services.backend.metadata.attribute.OtherMetaAttributesUtil;
import org.kie.workbench.common.services.backend.metadata.attribute.OtherMetaView;
import org.kie.workbench.common.services.shared.metadata.MetadataService;
import org.kie.workbench.common.services.shared.metadata.model.DiscussionRecord;
import org.kie.workbench.common.services.shared.metadata.model.Metadata;
import org.kie.workbench.common.services.shared.version.model.PortableVersionRecord;
import org.uberfire.backend.server.util.Paths;

@Service
@ApplicationScoped
public class MetadataServiceImpl
implements MetadataService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Paths paths;

    public Metadata getMetadata(org.uberfire.backend.vfs.Path resource) {
        Path path = this.paths.convert(resource);
        DublinCoreView dcoreView = (DublinCoreView)this.ioService.getFileAttributeView(path, DublinCoreView.class);
        DiscussionView discussView = (DiscussionView)this.ioService.getFileAttributeView(path, DiscussionView.class);
        OtherMetaView otherMetaView = (OtherMetaView)this.ioService.getFileAttributeView(path, OtherMetaView.class);
        final VersionAttributeView versionAttributeView = (VersionAttributeView)this.ioService.getFileAttributeView(path, VersionAttributeView.class);
        return MetadataBuilder.newMetadata().withPath(this.paths.convert(path.toRealPath(new LinkOption[0]))).withCheckinComment(versionAttributeView.readAttributes().history().records().size() > 0 ? ((VersionRecord)versionAttributeView.readAttributes().history().records().get(versionAttributeView.readAttributes().history().records().size() - 1)).comment() : null).withLastContributor(versionAttributeView.readAttributes().history().records().size() > 0 ? ((VersionRecord)versionAttributeView.readAttributes().history().records().get(versionAttributeView.readAttributes().history().records().size() - 1)).author() : null).withCreator(versionAttributeView.readAttributes().history().records().size() > 0 ? ((VersionRecord)versionAttributeView.readAttributes().history().records().get(0)).author() : null).withLastModified(new Date(versionAttributeView.readAttributes().lastModifiedTime().toMillis())).withDateCreated(new Date(versionAttributeView.readAttributes().creationTime().toMillis())).withSubject(dcoreView.readAttributes().subjects().size() > 0 ? (String)dcoreView.readAttributes().subjects().get(0) : null).withType(dcoreView.readAttributes().types().size() > 0 ? (String)dcoreView.readAttributes().types().get(0) : null).withExternalRelation(dcoreView.readAttributes().relations().size() > 0 ? (String)dcoreView.readAttributes().relations().get(0) : null).withExternalSource(dcoreView.readAttributes().sources().size() > 0 ? (String)dcoreView.readAttributes().sources().get(0) : null).withDescription(dcoreView.readAttributes().descriptions().size() > 0 ? (String)dcoreView.readAttributes().descriptions().get(0) : null).withCategories(otherMetaView.readAttributes().categories()).withDiscussion(discussView.readAttributes().discussion()).withVersion((List<VersionRecord>)new ArrayList<VersionRecord>(versionAttributeView.readAttributes().history().records().size()){
            {
                super(x0);
                for (VersionRecord record : versionAttributeView.readAttributes().history().records()) {
                    this.add(new PortableVersionRecord(record.id(), record.author(), record.comment(), record.date(), record.uri()));
                }
            }
        }).build();
    }

    public Map<String, Object> configAttrs(Map<String, Object> _attrs, final Metadata metadata) {
        PortablePreconditions.checkNotNull((String)"_attrs", _attrs);
        PortablePreconditions.checkNotNull((String)"metadata", (Object)metadata);
        Map<String, Object> attrs = DublinCoreAttributesUtil.cleanup(_attrs);
        attrs = DiscussionAttributesUtil.cleanup(attrs);
        attrs = OtherMetaAttributesUtil.cleanup(attrs);
        attrs.putAll(DiscussionAttributesUtil.toMap(new DiscussionAttributes(){

            @Override
            public List<DiscussionRecord> discussion() {
                return metadata.getDiscussion();
            }

            public FileTime lastModifiedTime() {
                return null;
            }

            public FileTime lastAccessTime() {
                return null;
            }

            public FileTime creationTime() {
                return null;
            }

            public boolean isRegularFile() {
                return false;
            }

            public boolean isDirectory() {
                return false;
            }

            public boolean isSymbolicLink() {
                return false;
            }

            public boolean isOther() {
                return false;
            }

            public long size() {
                return 0L;
            }

            public Object fileKey() {
                return null;
            }
        }, "*"));
        attrs.putAll(OtherMetaAttributesUtil.toMap(new OtherMetaAttributes(){

            @Override
            public List<String> categories() {
                return metadata.getCategories();
            }

            public FileTime lastModifiedTime() {
                return null;
            }

            public FileTime lastAccessTime() {
                return null;
            }

            public FileTime creationTime() {
                return null;
            }

            public boolean isRegularFile() {
                return false;
            }

            public boolean isDirectory() {
                return false;
            }

            public boolean isSymbolicLink() {
                return false;
            }

            public boolean isOther() {
                return false;
            }

            public long size() {
                return 0L;
            }

            public Object fileKey() {
                return null;
            }
        }, "*"));
        attrs.putAll(DublinCoreAttributesUtil.toMap((DublinCoreAttributes)new DublinCoreAttributes(){

            public List<String> titles() {
                return Collections.emptyList();
            }

            public List<String> creators() {
                return Collections.emptyList();
            }

            public List<String> subjects() {
                return new ArrayList<String>(1){
                    {
                        this.add(metadata.getSubject());
                    }
                };
            }

            public List<String> descriptions() {
                return new ArrayList<String>(1){
                    {
                        this.add(metadata.getDescription());
                    }
                };
            }

            public List<String> publishers() {
                return Collections.emptyList();
            }

            public List<String> contributors() {
                return Collections.emptyList();
            }

            public List<String> types() {
                return new ArrayList<String>(1){
                    {
                        this.add(metadata.getType());
                    }
                };
            }

            public List<String> formats() {
                return Collections.emptyList();
            }

            public List<String> identifiers() {
                return Collections.emptyList();
            }

            public List<String> sources() {
                return new ArrayList<String>(1){
                    {
                        this.add(metadata.getExternalSource());
                    }
                };
            }

            public List<String> languages() {
                return Collections.emptyList();
            }

            public List<String> relations() {
                return new ArrayList<String>(1){
                    {
                        this.add(metadata.getExternalRelation());
                    }
                };
            }

            public List<String> coverages() {
                return Collections.emptyList();
            }

            public List<String> rights() {
                return Collections.emptyList();
            }

            public FileTime lastModifiedTime() {
                return null;
            }

            public FileTime lastAccessTime() {
                return null;
            }

            public FileTime creationTime() {
                return null;
            }

            public boolean isRegularFile() {
                return false;
            }

            public boolean isDirectory() {
                return false;
            }

            public boolean isSymbolicLink() {
                return false;
            }

            public boolean isOther() {
                return false;
            }

            public long size() {
                return 0L;
            }

            public Object fileKey() {
                return null;
            }
        }, (String[])new String[]{"*"}));
        return attrs;
    }

    public Map<String, Object> setUpAttributes(org.uberfire.backend.vfs.Path path, Metadata metadata) {
        Map<Object, Object> attributes;
        try {
            attributes = this.ioService.readAttributes(this.paths.convert(path));
        }
        catch (NoSuchFileException ex) {
            attributes = new HashMap();
        }
        if (metadata != null) {
            attributes = this.configAttrs(attributes, metadata);
        }
        return attributes;
    }
}

