/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.metadata.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.commons.data.Pair;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.AbstractBasicFileAttributeView;
import org.kie.commons.java.nio.base.AbstractPath;
import org.kie.commons.java.nio.base.NeedsPreloadedAttrs;
import org.kie.commons.java.nio.base.NotImplementedException;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributeView;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributes;
import org.kie.commons.java.nio.file.attribute.FileTime;
import org.kie.commons.validation.Preconditions;
import org.kie.workbench.common.services.backend.metadata.attribute.DiscussionAttributes;
import org.kie.workbench.common.services.backend.metadata.attribute.DiscussionAttributesUtil;
import org.kie.workbench.common.services.shared.metadata.model.DiscussionRecord;

public class DiscussionView
extends AbstractBasicFileAttributeView<AbstractPath>
implements NeedsPreloadedAttrs {
    public static final String DISCUSS = "discuss";
    public static final String TIMESTAMP = "discuss.ts";
    public static final String AUTHOR = "discuss.author";
    public static final String NOTE = "discuss.note";
    private final DiscussionAttributes attrs;

    /*
     * WARNING - void declaration
     */
    public DiscussionView(AbstractPath path) {
        super((Path)path);
        void var7_9;
        Map content = path.getAttrStorage().getContent();
        HashMap<Object, Long> timestamps = new HashMap<Object, Long>(content.size());
        HashMap<Object, String> authors = new HashMap<Object, String>(content.size());
        HashMap<Object, String> notes = new HashMap<Object, String>(content.size());
        for (Map.Entry<String, Object> entry : content.entrySet()) {
            Pair<Integer, Object> result;
            if (((String)entry.getKey()).startsWith(TIMESTAMP)) {
                result = this.extractValue(entry);
                timestamps.put(result.getK1(), (Long)result.getK2());
                continue;
            }
            if (((String)entry.getKey()).startsWith(AUTHOR)) {
                result = this.extractValue(entry);
                authors.put(result.getK1(), result.getK2().toString());
                continue;
            }
            if (!entry.getKey().startsWith(NOTE)) continue;
            result = this.extractValue(entry);
            notes.put(result.getK1(), result.getK2().toString());
        }
        final ArrayList<DiscussionRecord> result = new ArrayList<DiscussionRecord>(timestamps.size());
        boolean bl = false;
        while (var7_9 < timestamps.size()) {
            Long ts = (Long)timestamps.get((int)var7_9);
            String author = (String)authors.get((int)var7_9);
            String note = (String)notes.get((int)var7_9);
            result.add(new DiscussionRecord(ts.longValue(), author, note));
            ++var7_9;
        }
        Collections.sort(result, new Comparator<DiscussionRecord>(){

            @Override
            public int compare(DiscussionRecord o1, DiscussionRecord o2) {
                return o1.getTimestamp().compareTo(o2.getTimestamp());
            }
        });
        final BasicFileAttributes basicFileAttributes = ((BasicFileAttributeView)path.getFileSystem().provider().getFileAttributeView((Path)path, BasicFileAttributeView.class, new LinkOption[0])).readAttributes();
        this.attrs = new DiscussionAttributes(){

            @Override
            public List<DiscussionRecord> discussion() {
                return result;
            }

            public FileTime lastModifiedTime() {
                return basicFileAttributes.lastModifiedTime();
            }

            public FileTime lastAccessTime() {
                return basicFileAttributes.lastAccessTime();
            }

            public FileTime creationTime() {
                return basicFileAttributes.creationTime();
            }

            public boolean isRegularFile() {
                return basicFileAttributes.isRegularFile();
            }

            public boolean isDirectory() {
                return basicFileAttributes.isDirectory();
            }

            public boolean isSymbolicLink() {
                return basicFileAttributes.isSymbolicLink();
            }

            public boolean isOther() {
                return basicFileAttributes.isOther();
            }

            public long size() {
                return basicFileAttributes.size();
            }

            public Object fileKey() {
                return basicFileAttributes.fileKey();
            }
        };
    }

    private Pair<Integer, Object> extractValue(Map.Entry<String, Object> entry) {
        int start = entry.getKey().indexOf(91);
        if (start < 0) {
            return Pair.newPair((Object)0, (Object)entry.getValue());
        }
        int end = entry.getKey().indexOf(93);
        return Pair.newPair((Object)Integer.valueOf(entry.getKey().substring(start + 1, end)), (Object)entry.getValue());
    }

    public String name() {
        return DISCUSS;
    }

    public DiscussionAttributes readAttributes() throws IOException {
        return this.attrs;
    }

    public Map<String, Object> readAttributes(String ... attributes) {
        return DiscussionAttributesUtil.toMap(this.readAttributes(), attributes);
    }

    public Class<? extends BasicFileAttributeView>[] viewTypes() {
        return new Class[]{DiscussionView.class};
    }

    public void setAttribute(String attribute, Object value) throws IOException {
        Preconditions.checkNotEmpty((String)"attribute", (String)attribute);
        Preconditions.checkCondition((String)"invalid attribute", (boolean)attribute.equals(this.name()));
        throw new NotImplementedException();
    }
}

