/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.metadata.attribute;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kie.commons.data.Pair;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.AbstractBasicFileAttributeView;
import org.kie.commons.java.nio.base.AbstractPath;
import org.kie.commons.java.nio.base.NeedsPreloadedAttrs;
import org.kie.commons.java.nio.base.NotImplementedException;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributeView;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributes;
import org.kie.commons.java.nio.file.attribute.FileTime;
import org.kie.commons.validation.Preconditions;
import org.kie.workbench.common.services.backend.metadata.attribute.OtherMetaAttributes;
import org.kie.workbench.common.services.backend.metadata.attribute.OtherMetaAttributesUtil;

public class OtherMetaView
extends AbstractBasicFileAttributeView<AbstractPath>
implements NeedsPreloadedAttrs {
    public static final String CATEGORY = "othermeta.category";
    public static final String MODE = "othermeta.mode";
    private static final Set<String> PROPERTIES = new HashSet<String>(){
        {
            this.add(OtherMetaView.CATEGORY);
            this.add(OtherMetaView.MODE);
        }
    };
    private final OtherMetaAttributes attrs;

    public OtherMetaView(AbstractPath path) {
        super((Path)path);
        Map content = path.getAttrStorage().getContent();
        TreeMap<Object, String> _categories = new TreeMap<Object, String>();
        for (Map.Entry<String, Object> entry : content.entrySet()) {
            if (!((String)entry.getKey()).startsWith(CATEGORY)) continue;
            Pair<Integer, Object> result = this.extractValue(entry);
            _categories.put(result.getK1(), result.getK2().toString());
        }
        final BasicFileAttributes fileAttrs = ((BasicFileAttributeView)path.getFileSystem().provider().getFileAttributeView((Path)path, BasicFileAttributeView.class, new LinkOption[0])).readAttributes();
        final ArrayList arrayList = new ArrayList(_categories.values());
        this.attrs = new OtherMetaAttributes(){

            @Override
            public List<String> categories() {
                return arrayList;
            }

            public FileTime lastModifiedTime() {
                return fileAttrs.lastModifiedTime();
            }

            public FileTime lastAccessTime() {
                return fileAttrs.lastAccessTime();
            }

            public FileTime creationTime() {
                return fileAttrs.creationTime();
            }

            public boolean isRegularFile() {
                return fileAttrs.isRegularFile();
            }

            public boolean isDirectory() {
                return fileAttrs.isDirectory();
            }

            public boolean isSymbolicLink() {
                return fileAttrs.isSymbolicLink();
            }

            public boolean isOther() {
                return fileAttrs.isOther();
            }

            public long size() {
                return fileAttrs.size();
            }

            public Object fileKey() {
                return fileAttrs.fileKey();
            }
        };
    }

    private Pair<Integer, Object> extractValue(Map.Entry<String, Object> entry) {
        int start = entry.getKey().indexOf(91);
        if (start < 0) {
            return Pair.newPair((Object)0, (Object)entry.getValue());
        }
        int end = entry.getKey().indexOf(93);
        return Pair.newPair((Object)Integer.valueOf(entry.getKey().substring(start + 1, end)), (Object)entry.getValue());
    }

    public String name() {
        return "othermeta";
    }

    public OtherMetaAttributes readAttributes() throws IOException {
        return this.attrs;
    }

    public Map<String, Object> readAttributes(String ... attributes) {
        return OtherMetaAttributesUtil.toMap(this.readAttributes(), attributes);
    }

    public Class<? extends BasicFileAttributeView>[] viewTypes() {
        return new Class[]{OtherMetaView.class};
    }

    public void setAttribute(String attribute, Object value) throws IOException {
        Preconditions.checkNotEmpty((String)"attribute", (String)attribute);
        Preconditions.checkCondition((String)"invalid attribute", (boolean)PROPERTIES.contains(attribute));
        throw new NotImplementedException();
    }
}

