/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.rulename;

import java.util.HashSet;
import java.util.Set;

public class RuleNameResolver {
    private HashSet<String> ruleNames = new HashSet();
    private String drl;
    private boolean currentRuleNameHasDoubleQuotes = false;
    private boolean currentRuleNameHasSingleQuotes = false;
    private String packageName;

    public RuleNameResolver(String drl) {
        this.drl = drl;
        this.resolve();
    }

    private Set<String> resolve() {
        while (this.drl.contains("//")) {
            int commentStart = this.drl.indexOf("//");
            int endOfComment = this.drl.indexOf("\n", commentStart);
            if (endOfComment >= 0) {
                this.drl = this.drl.substring(0, commentStart) + this.drl.substring(endOfComment);
                continue;
            }
            this.drl = this.drl.substring(0, commentStart);
        }
        while (this.hasMultiLineComment()) {
            this.clearMultiLineComment();
        }
        this.findPackage();
        while (this.hasRule()) {
            String ruleLine = this.getNextRuleHeaderLine();
            this.stripNameFromLine(this.ruleNames, ruleLine);
            this.drl = this.drl.substring(this.drl.indexOf(ruleLine) + ruleLine.length());
        }
        return this.ruleNames;
    }

    private void findPackage() {
        if (this.drl.contains("package ")) {
            String text = this.drl.substring(this.drl.indexOf("package") + "package".length()).trim();
            int endIndex = this.getEndOfPackageLine(text);
            this.packageName = text.substring(0, endIndex).trim();
        } else {
            this.packageName = "";
        }
    }

    private int getEndOfPackageLine(String text) {
        int endIndex = 0;
        int semiColonIndex = text.indexOf(";");
        int eofIndex = text.indexOf("\n");
        if (semiColonIndex == -1 && eofIndex == -1) {
            return text.length();
        }
        if (semiColonIndex == -1 && eofIndex != -1) {
            endIndex = eofIndex;
        } else if (semiColonIndex != -1 && eofIndex == -1) {
            endIndex = semiColonIndex;
        } else if (semiColonIndex > eofIndex) {
            endIndex = eofIndex;
        } else if (semiColonIndex < eofIndex) {
            endIndex = semiColonIndex;
        }
        return endIndex;
    }

    private void clearMultiLineComment() {
        int startIndexOfTheComment = this.drl.indexOf("/*");
        this.drl = this.drl.substring(0, startIndexOfTheComment) + this.drl.substring(this.getEndOfComment());
    }

    private int getEndOfComment() {
        int endOfComment = this.drl.indexOf("*/") + "*/".length();
        while (this.endOfNextComment(endOfComment) >= 0) {
            int endOfNextComment = this.endOfNextComment(endOfComment) + "*/".length();
            String substring = this.drl.substring(endOfComment, endOfNextComment);
            if (endOfNextComment < 0 || this.hasMultiLineComment(substring)) break;
            endOfComment = endOfNextComment;
        }
        return endOfComment;
    }

    private boolean hasMultiLineComment(String substring) {
        return substring.contains("*/") && substring.contains("/*") && substring.indexOf("/*") < substring.indexOf("*/");
    }

    private int endOfNextComment(int endOfComment) {
        return this.drl.indexOf("*/", endOfComment);
    }

    private boolean hasMultiLineComment() {
        return this.drl.indexOf("/*") >= 0;
    }

    private String getNextRuleHeaderLine() {
        int beginIndex = this.getRuleIndex();
        return this.drl.substring(beginIndex, this.drl.indexOf("\n", beginIndex));
    }

    private int getRuleIndex() {
        int beginIndexWithQuotes;
        int ruleIndex = this.drl.indexOf("rule");
        if (ruleIndex >= (beginIndexWithQuotes = this.getBeginIndexWithQuotes()) && beginIndexWithQuotes >= 0) {
            return beginIndexWithQuotes;
        }
        this.currentRuleNameHasDoubleQuotes = false;
        this.currentRuleNameHasSingleQuotes = false;
        return ruleIndex;
    }

    private int getBeginIndexWithQuotes() {
        int doubleQuotes = this.drl.indexOf("rule \"");
        int singleQuotes = this.drl.indexOf("rule '");
        if (singleQuotes == -1 || doubleQuotes <= singleQuotes && doubleQuotes >= 0) {
            this.currentRuleNameHasDoubleQuotes = true;
            return doubleQuotes;
        }
        this.currentRuleNameHasSingleQuotes = true;
        return singleQuotes;
    }

    private boolean hasRule() {
        return this.getRuleIndex() >= 0;
    }

    private void stripNameFromLine(HashSet<String> ruleNames, String ruleLine) {
        int endIndex = this.getRuleNameEndIndex(ruleLine = this.removeTheWorldRuleAndWhiteSpacesFromTheBeginning(ruleLine));
        if (endIndex >= 0) {
            ruleNames.add(ruleLine.substring(0, endIndex));
        } else {
            ruleNames.add(ruleLine);
        }
    }

    private String removeTheWorldRuleAndWhiteSpacesFromTheBeginning(String ruleLine) {
        return ruleLine.substring(this.getRuleFrontBitLength()).trim();
    }

    private int getRuleNameEndIndex(String ruleLine) {
        if (this.currentRuleNameHasDoubleQuotes) {
            return ruleLine.indexOf("\"");
        }
        if (this.currentRuleNameHasSingleQuotes) {
            return ruleLine.indexOf("'");
        }
        return ruleLine.indexOf(" ");
    }

    private int getRuleFrontBitLength() {
        if (this.currentRuleNameHasQuotes()) {
            return "rule \"".length();
        }
        return "rule".length();
    }

    private boolean currentRuleNameHasQuotes() {
        return this.currentRuleNameHasDoubleQuotes || this.currentRuleNameHasSingleQuotes;
    }

    public Set<String> getRuleNames() {
        return new HashSet<String>(this.ruleNames);
    }

    public String getPackageName() {
        return this.packageName;
    }
}

