/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.rulename;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.rulename.RuleNameResolver;
import org.kie.workbench.common.services.backend.source.SourceServices;
import org.kie.workbench.common.services.shared.rulename.RuleNamesService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceCopied;
import org.uberfire.workbench.events.ResourceCopiedEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamed;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Service
@ApplicationScoped
public class RuleNameServiceImpl
implements RuleNamesService {
    private SourceServices sourceServices;
    private ProjectService projectService;
    private IOService ioService;
    private final Map<Project, RuleNamesByPackageMap> ruleNames = new HashMap<Project, RuleNamesByPackageMap>();
    private final Map<org.uberfire.backend.vfs.Path, PathHandle> pathHandles = new HashMap<org.uberfire.backend.vfs.Path, PathHandle>();

    public RuleNameServiceImpl() {
    }

    @Inject
    public RuleNameServiceImpl(SourceServices sourceServices, ProjectService projectService, @Named(value="ioStrategy") IOService ioService) {
        this.sourceServices = sourceServices;
        this.projectService = projectService;
        this.ioService = ioService;
    }

    public Collection<String> getRuleNames(org.uberfire.backend.vfs.Path path, String packageName) {
        Project project = this.projectService.resolveProject(path);
        if (project == null) {
            return Collections.emptyList();
        }
        return this.getRuleNames(project, packageName);
    }

    public void onProjectContextChange(@Observes ProjectContextChangeEvent event) {
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath())));
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            if (this.pathHandles.containsKey(path)) continue;
            this.processResourceAdd(Paths.convert((Path)path));
        }
    }

    public void processResourceAdd(@Observes ResourceAddedEvent resourceAddedEvent) {
        this.processResourceAdd(resourceAddedEvent.getPath());
    }

    public void processResourceDelete(@Observes ResourceDeletedEvent resourceDeletedEvent) {
        this.processResourceDelete(resourceDeletedEvent.getPath());
    }

    public void processResourceUpdate(@Observes ResourceUpdatedEvent resourceUpdatedEvent) {
        this.processResourceUpdate(resourceUpdatedEvent.getPath());
    }

    public void processResourceCopied(@Observes ResourceCopiedEvent resourceCopiedEvent) {
        if (this.isObservableResource(resourceCopiedEvent.getDestinationPath())) {
            this.addRuleNames(resourceCopiedEvent.getDestinationPath());
        }
    }

    public void processResourceRenamed(@Observes ResourceRenamedEvent resourceRenamedEvent) {
        this.processRename(resourceRenamedEvent.getPath(), resourceRenamedEvent.getDestinationPath());
    }

    public void processBatchChanges(@Observes ResourceBatchChangesEvent resourceBatchChangesEvent) {
        for (org.uberfire.backend.vfs.Path path : resourceBatchChangesEvent.getBatch().keySet()) {
            Collection resourceChanges = (Collection)resourceBatchChangesEvent.getBatch().get(path);
            for (ResourceChange resourceChange : resourceChanges) {
                switch (resourceChange.getType()) {
                    case ADD: {
                        this.processResourceAdd(path);
                        break;
                    }
                    case UPDATE: {
                        this.processResourceUpdate(path);
                        break;
                    }
                    case DELETE: {
                        this.processResourceDelete(path);
                        break;
                    }
                    case COPY: {
                        this.processResourceAdd(((ResourceCopied)resourceChange).getDestinationPath());
                        break;
                    }
                    case RENAME: {
                        ResourceRenamed resourceRenamed = (ResourceRenamed)resourceChange;
                        this.processRename(path, resourceRenamed.getDestinationPath());
                    }
                }
            }
        }
    }

    private void processResourceAdd(org.uberfire.backend.vfs.Path path) {
        if (this.isObservableResource(path)) {
            this.addRuleNames(path);
        }
    }

    private void processResourceDelete(org.uberfire.backend.vfs.Path path) {
        if (this.isObservableResource(path)) {
            this.deleteRuleNames(path);
        }
    }

    private void processResourceUpdate(org.uberfire.backend.vfs.Path path) {
        if (this.isObservableResource(path)) {
            this.deleteRuleNames(path);
            this.addRuleNames(path);
        }
    }

    private void processRename(org.uberfire.backend.vfs.Path path, org.uberfire.backend.vfs.Path destinationPath) {
        if (this.isObservableResource(path)) {
            this.deleteRuleNames(path);
        }
        if (this.isObservableResource(destinationPath)) {
            this.addRuleNames(destinationPath);
        }
    }

    private void addRuleNames(org.uberfire.backend.vfs.Path path) {
        Path convertedPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.sourceServices.hasServiceFor(convertedPath)) {
            String drl = this.sourceServices.getServiceFor(convertedPath).getSource(convertedPath);
            this.addRuleNames(path, drl);
        } else if (path.getFileName().endsWith(".drl")) {
            this.addRuleNames(path, this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRuleNames(org.uberfire.backend.vfs.Path path, String drl) {
        Map<Project, RuleNamesByPackageMap> map = this.ruleNames;
        synchronized (map) {
            Project project = this.projectService.resolveProject(path);
            RuleNameResolver ruleNameResolver = new RuleNameResolver(drl);
            if (this.ruleNames.containsKey(project)) {
                this.ruleNames.get(project).add(ruleNameResolver.getPackageName(), ruleNameResolver.getRuleNames());
            } else {
                RuleNamesByPackageMap map2 = new RuleNamesByPackageMap();
                map2.add(ruleNameResolver.getPackageName(), ruleNameResolver.getRuleNames());
                this.ruleNames.put(project, map2);
            }
            this.pathHandles.put(path, new PathHandle(ruleNameResolver.getPackageName(), ruleNameResolver.getRuleNames()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRuleNames(org.uberfire.backend.vfs.Path path) {
        Map<Project, RuleNamesByPackageMap> map = this.ruleNames;
        synchronized (map) {
            if (this.pathHandles.containsKey(path)) {
                PathHandle pathHandle = this.pathHandles.get(path);
                Project project = this.projectService.resolveProject(path);
                for (String deleteRuleName : pathHandle.ruleNames) {
                    Set<String> strings = this.ruleNames.get(project).get(pathHandle.packageName);
                    strings.remove(deleteRuleName);
                }
            }
        }
    }

    private boolean isObservableResource(org.uberfire.backend.vfs.Path path) {
        return path != null && !path.getFileName().startsWith(".") && (path.getFileName().endsWith(".drl") || path.getFileName().endsWith(".gdst") || path.getFileName().endsWith(".rdrl") || path.getFileName().endsWith(".rdslr") || path.getFileName().endsWith(".template"));
    }

    public Set<String> getRuleNames(Project project, String packageName) {
        RuleNamesByPackageMap map = this.ruleNames.get(project);
        if (map == null) {
            return new HashSet<String>();
        }
        Set<String> result = map.get(packageName);
        if (result == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(result);
    }

    private class PathHandle {
        String packageName;
        Set<String> ruleNames;

        public PathHandle(String packageName, Set<String> ruleNames) {
            this.packageName = packageName;
            this.ruleNames = ruleNames;
        }
    }

    private class RuleNamesByPackageMap {
        HashMap<String, Set<String>> map = new HashMap();

        private RuleNamesByPackageMap() {
        }

        void add(String packageName, Set<String> ruleNames) {
            if (this.map.containsKey(packageName)) {
                this.map.get(packageName).addAll(ruleNames);
            } else {
                this.map.put(packageName, ruleNames);
            }
        }

        public Set<String> get(String packageName) {
            return this.map.get(packageName);
        }
    }
}

