/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.service;

import java.util.Date;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.services.backend.source.SourceServices;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

public abstract class KieService {
    private static final Logger logger = LoggerFactory.getLogger(KieService.class);
    @Inject
    protected MetadataService metadataService;
    @Inject
    protected SourceServices sourceServices;
    @Inject
    protected KieProjectService projectService;
    @Inject
    protected User identity;
    @Inject
    protected SessionInfo sessionInfo;

    public Overview loadOverview(org.uberfire.backend.vfs.Path path) {
        Overview overview = new Overview();
        try {
            overview.setMetadata(this.metadataService.getMetadata(path));
        }
        catch (Exception e) {
            logger.warn("No metadata found for file: " + path.getFileName() + ", full path [" + path.toString() + "]");
        }
        overview.setPreview(this.getSource(path));
        KieProject project = (KieProject)this.projectService.resolveProject(path);
        if (project == null) {
            logger.info("File: " + path.getFileName() + ", full path [" + path.toString() + "] was not within a Project. Project Name cannot be set.");
        } else {
            overview.setProjectName(project.getProjectName());
        }
        return overview;
    }

    public String getSource(org.uberfire.backend.vfs.Path path) {
        Path convertedPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.sourceServices.hasServiceFor(convertedPath)) {
            return this.sourceServices.getServiceFor(convertedPath).getSource(convertedPath);
        }
        return "";
    }

    protected CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getIdentifier();
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return co;
    }
}

