/*
 * Copyright 2014 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.services.backend.validation;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.vfs.Path;

/**
 * Java file name validator.
 */
@ApplicationScoped
public class JavaFileNameValidator implements FileNameValidator {

    @Inject
    KieProjectService projectService;

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean accept( String fileName ) {
        return fileName != null && fileName.endsWith( ".java" );
    }

    @Override
    public boolean accept( Path path ) {
        if ( !accept( path.getFileName() ) ) {
            return false;
        }
        Package currentPackage = projectService.resolvePackage( path );
        return currentPackage != null && !"".equals( currentPackage.getPackageName() );
    }

    @Override
    public boolean isValid( String value ) {
        return value.endsWith( ".java" ) && ValidationUtils.isJavaIdentifier( value.substring( 0, value.indexOf( ".java" ) ) ) && ValidationUtils.isFileName( value );
    }
}
