/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.ProjectConfigurationContentHandler;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.shared.project.ProjectImportsContent;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;

@Service
@ApplicationScoped
public class ProjectImportsServiceImpl
extends KieService
implements ProjectImportsService {
    protected IOService ioService;
    protected ProjectConfigurationContentHandler projectConfigurationContentHandler;
    private MetadataService metadataService;

    public ProjectImportsServiceImpl() {
    }

    @Inject
    public ProjectImportsServiceImpl(@Named(value="ioStrategy") IOService ioService, ProjectConfigurationContentHandler projectConfigurationContentHandler, MetadataService metadataService) {
        this.ioService = ioService;
        this.projectConfigurationContentHandler = projectConfigurationContentHandler;
        this.metadataService = metadataService;
    }

    public ProjectImportsContent loadContent(Path path) {
        return new ProjectImportsContent(this.load(path), this.loadOverview(path));
    }

    public ProjectImports load(Path path) {
        String content = this.ioService.readAllString(Paths.convert((Path)path));
        return this.projectConfigurationContentHandler.toModel(content);
    }

    public Path save(Path resource, ProjectImports projectImports, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((Path)resource), this.projectConfigurationContentHandler.toString(projectImports), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[0]);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

