/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.backend.file.AntPathMatcher;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class PackageNameWhiteList {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private IOService ioService;

    @Inject
    public PackageNameWhiteList(@Named(value="ioStrategy") IOService ioService) {
        this.ioService = ioService;
    }

    public Set<String> filterPackageNames(Project project, Collection<String> packageNames) {
        String content;
        HashSet<String> packageNamesWhiteList = new HashSet<String>();
        if (packageNames == null) {
            return packageNamesWhiteList;
        }
        packageNamesWhiteList.addAll(packageNames);
        if (!(project instanceof KieProject)) {
            return packageNamesWhiteList;
        }
        Path packageNamesWhiteListPath = Paths.convert((org.uberfire.backend.vfs.Path)((KieProject)project).getPackageNamesWhiteList());
        if (Files.exists((Path)packageNamesWhiteListPath, (LinkOption[])new LinkOption[0]) && (content = this.ioService.readAllString(packageNamesWhiteListPath)) != null && !content.trim().isEmpty()) {
            packageNamesWhiteList.clear();
            String[] patterns = content.split(System.getProperty("line.separator"));
            for (int i = 0; i < patterns.length; ++i) {
                patterns[i] = patterns[i].replaceAll("\\.", "/");
            }
            HashMap<String, String> packageNamePaths = new HashMap<String, String>();
            for (String packageName : packageNames) {
                packageNamePaths.put(packageName, packageName.replaceAll("\\.", "/"));
            }
            for (String pattern : patterns) {
                for (Map.Entry pnp : packageNamePaths.entrySet()) {
                    if (!ANT_PATH_MATCHER.match(pattern, (String)pnp.getValue())) continue;
                    packageNamesWhiteList.add((String)pnp.getKey());
                }
            }
        }
        return packageNamesWhiteList;
    }
}

