/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.rulename;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePackageNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueProjectRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.rulename.RuleNamesService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class RuleNameServiceImpl
implements RuleNamesService {
    @Inject
    private RefactoringQueryService queryService;
    @Inject
    private KieProjectService projectService;

    public Collection<String> getRuleNames(Path path, String packageName) {
        Project project = this.projectService.resolveProject(path);
        if (project == null) {
            return Collections.emptyList();
        }
        return this.queryRuleNames(project, packageName);
    }

    private List<String> queryRuleNames(final Project project, final String packageName) {
        List results = this.queryService.query("FindRulesByProjectQuery", (Set)new HashSet<ValueIndexTerm>(){
            {
                this.add(new ValueProjectRootPathIndexTerm(project.getRootPath().toURI()));
                this.add(new ValuePackageNameIndexTerm(packageName));
            }
        }, false);
        ArrayList<String> ruleNames = new ArrayList<String>();
        for (RefactoringPageRow row : results) {
            ruleNames.add((String)row.getValue());
        }
        Collections.sort(ruleNames);
        return ruleNames;
    }
}

