/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.shared.security.KieWorkbenchSecurityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@ApplicationScoped
public class KieWorkbenchSecurityServiceImpl
implements KieWorkbenchSecurityService {
    private static final Logger logger = LoggerFactory.getLogger(KieWorkbenchSecurityServiceImpl.class);

    public String loadPolicy() {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("workbench-policy.properties");
            if (is != null) {
                String policy = KieWorkbenchSecurityServiceImpl.fromStream(is);
                return policy;
            }
        }
        catch (Exception e) {
            logger.error("Workbench security policy couldn't be loaded.", (Throwable)e);
        }
        return "";
    }

    public static String fromStream(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder out = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            out.append(line).append("\n");
        }
        return out.toString();
    }
}

