/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.guvnor.common.services.backend.file.DotFileFilter;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.BaseFileNameResolver;
import org.kie.workbench.common.services.backend.builder.BuildMessageBuilder;
import org.kie.workbench.common.services.backend.builder.Handles;
import org.kie.workbench.common.services.backend.builder.LRUProjectDependenciesClassLoaderCache;
import org.kie.workbench.common.services.backend.builder.MessageConverter;
import org.kie.workbench.common.services.backend.builder.PackageNameWhiteList;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceChangeType;

public class Builder {
    private static final Logger logger = LoggerFactory.getLogger(Builder.class);
    private static final String ERROR_EXTERNAL_CLASS_VERIFICATON = "Verification of class {0} failed and will not be available for authoring.\nPlease check the necessary external dependencies for this project are configured correctly.";
    private static final String ERROR_CLASS_NOT_FOUND = "Definition of class \"{0}\" was not found.\nPlease check the necessary external dependencies for this project are configured correctly.";
    private KieBuilder kieBuilder;
    private final KieServices kieServices;
    private final KieFileSystem kieFileSystem;
    private final Project project;
    private final GAV projectGAV;
    private final Path projectRoot;
    private final String projectPrefix;
    private final Handles handles = new Handles();
    private final IOService ioService;
    private final KieProjectService projectService;
    private final ProjectImportsService importsService;
    private final List<BuildValidationHelper> buildValidationHelpers;
    private final PackageNameWhiteList packageNameWhiteList;
    private final Map<Path, BuildValidationHelper> nonKieResourceValidationHelpers = new HashMap<Path, BuildValidationHelper>();
    private final Map<Path, List<ValidationMessage>> nonKieResourceValidationHelperMessages = new HashMap<Path, List<ValidationMessage>>();
    private final DirectoryStream.Filter<Path> javaResourceFilter = new JavaFileFilter();
    private final DirectoryStream.Filter<Path> dotFileFilter = new DotFileFilter();
    private Set<String> javaResources = new HashSet<String>();
    private LRUProjectDependenciesClassLoaderCache dependenciesClassLoaderCache;

    public Builder(Project project, IOService ioService, KieProjectService projectService, ProjectImportsService importsService, List<BuildValidationHelper> buildValidationHelpers, PackageNameWhiteList packageNameWhiteList, LRUProjectDependenciesClassLoaderCache dependenciesClassLoaderCache) {
        this.project = project;
        this.ioService = ioService;
        this.projectService = projectService;
        this.importsService = importsService;
        this.buildValidationHelpers = buildValidationHelpers;
        this.packageNameWhiteList = packageNameWhiteList;
        this.projectGAV = project.getPom().getGav();
        this.projectRoot = Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath());
        this.projectPrefix = this.projectRoot.toUri().toString();
        this.kieServices = KieServices.Factory.get();
        this.kieFileSystem = this.kieServices.newKieFileSystem();
        this.dependenciesClassLoaderCache = dependenciesClassLoaderCache;
        DirectoryStream directoryStream = Files.newDirectoryStream((Path)this.projectRoot);
        this.visitPaths((DirectoryStream<Path>)directoryStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResults build() {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            String msg;
            this.kieBuilder = this.kieServices.newKieBuilder(this.kieFileSystem);
            BuildResults results = new BuildResults(this.projectGAV);
            try {
                Results kieResults = this.kieBuilder.buildAll().getResults();
                results.addAllBuildMessages(MessageConverter.convertMessages(kieResults.getMessages(), this.handles));
            }
            catch (LinkageError e) {
                msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage());
                logger.warn(msg);
                results.addBuildMessage(BuildMessageBuilder.makeWarningMessage(msg));
            }
            catch (Throwable e) {
                msg = e.getLocalizedMessage();
                logger.error(msg, e);
                results.addBuildMessage(BuildMessageBuilder.makeErrorMessage(msg));
            }
            for (Map.Entry<Path, BuildValidationHelper> e : this.nonKieResourceValidationHelpers.entrySet()) {
                org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)e.getKey());
                List validationMessages = e.getValue().validate(vfsPath);
                this.nonKieResourceValidationHelperMessages.put(e.getKey(), validationMessages);
                results.addAllBuildMessages(MessageConverter.convertValidationMessages(validationMessages));
            }
            Path nioExternalImportsPath = this.projectRoot.resolve("project.imports");
            if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
                org.uberfire.backend.vfs.Path externalImportsPath = Paths.convert((Path)nioExternalImportsPath);
                ProjectImports projectImports = (ProjectImports)this.importsService.load(externalImportsPath);
                Imports imports = projectImports.getImports();
                for (Import item : imports.getImports()) {
                    String fullyQualifiedClassName = item.getType();
                    try {
                        Class<?> clazz = this.getClass().getClassLoader().loadClass(item.getType());
                    }
                    catch (ClassNotFoundException cnfe) {
                        logger.warn(cnfe.getMessage());
                        String msg2 = MessageFormat.format(ERROR_CLASS_NOT_FOUND, fullyQualifiedClassName);
                        results.addBuildMessage(BuildMessageBuilder.makeWarningMessage(msg2));
                    }
                }
            }
            KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)((InternalKieBuilder)this.kieBuilder).getKieModuleIgnoringErrors());
            Set<String> packageNamesWhiteList = this.packageNameWhiteList.filterPackageNames(this.project, kieModuleMetaData.getPackages());
            this.updateDependenciesClassLoader(this.project, kieModuleMetaData);
            for (String packageName : kieModuleMetaData.getPackages()) {
                if (!packageNamesWhiteList.contains(packageName)) continue;
                for (String className : kieModuleMetaData.getClasses(packageName)) {
                    String msg3;
                    String fullyQualifiedClassName = packageName + "." + className;
                    try {
                        Class clazz = kieModuleMetaData.getClass(packageName, className);
                        if (clazz != null) {
                            TypeSource typeSource = this.getClassSource(kieModuleMetaData, clazz);
                            if (TypeSource.JAVA_DEPENDENCY != typeSource) continue;
                            this.verifyExternalClass(clazz);
                            continue;
                        }
                        msg3 = MessageFormat.format(ERROR_EXTERNAL_CLASS_VERIFICATON, fullyQualifiedClassName);
                        logger.warn(msg3);
                    }
                    catch (Throwable e) {
                        msg3 = MessageFormat.format(ERROR_EXTERNAL_CLASS_VERIFICATON, fullyQualifiedClassName);
                        logger.warn(msg3);
                        results.addBuildMessage(BuildMessageBuilder.makeWarningMessage(msg3));
                    }
                }
            }
            return results;
        }
    }

    private void updateDependenciesClassLoader(Project project, KieModuleMetaData kieModuleMetaData) {
        KieProject kieProject = (KieProject)this.projectService.resolveProject(project.getPomXMLPath());
        if (kieProject != null) {
            this.dependenciesClassLoaderCache.setDependenciesClassLoader(kieProject, LRUProjectDependenciesClassLoaderCache.buildClassLoader(kieProject, kieModuleMetaData));
        }
    }

    private void verifyExternalClass(Class clazz) {
        clazz.getDeclaredConstructors();
        clazz.getDeclaredFields();
        clazz.getDeclaredMethods();
        clazz.getDeclaredClasses();
        clazz.getDeclaredAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults addResource(Path resource) {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
            if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) {
                return new IncrementalBuildResults(this.projectGAV);
            }
            this.checkAFullBuildHasBeenPerformed();
            IncrementalBuildResults results = new IncrementalBuildResults(this.projectGAV);
            BuildValidationHelper validator = this.getBuildValidationHelper(resource);
            if (validator != null) {
                List addedValidationMessages = validator.validate(Paths.convert((Path)resource));
                results.addAllAddedMessages(MessageConverter.convertValidationMessages(addedValidationMessages));
                results.addAllRemovedMessages(MessageConverter.convertValidationMessages(this.nonKieResourceValidationHelperMessages.remove(resource)));
                this.nonKieResourceValidationHelpers.put(resource, validator);
                this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
            }
            String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
            InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
            this.addJavaClass(resource);
            this.handles.put(BaseFileNameResolver.getBaseFileName(destinationPath), Paths.convert((Path)resource));
            this.buildIncrementally(results, destinationPath);
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults deleteResource(Path resource) {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
            this.checkAFullBuildHasBeenPerformed();
            IncrementalBuildResults results = new IncrementalBuildResults(this.projectGAV);
            BuildValidationHelper validator = this.getBuildValidationHelper(resource);
            if (validator != null) {
                this.nonKieResourceValidationHelpers.remove(resource);
                results.addAllRemovedMessages(MessageConverter.convertValidationMessages(this.nonKieResourceValidationHelperMessages.remove(resource)));
            }
            String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
            this.kieFileSystem.delete(new String[]{destinationPath});
            this.removeJavaClass(resource);
            this.buildIncrementally(results, destinationPath);
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults updateResource(Path resource) {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            return this.addResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalBuildResults applyBatchResourceChanges(Map<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> changes) {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            PortablePreconditions.checkNotNull((String)"changes", changes);
            this.checkAFullBuildHasBeenPerformed();
            ArrayList<String> changedFilesKieBuilderPaths = new ArrayList<String>();
            ArrayList<ValidationMessage> nonKieResourceValidatorAddedMessages = new ArrayList<ValidationMessage>();
            ArrayList<ValidationMessage> nonKieResourceValidatorRemovedMessages = new ArrayList<ValidationMessage>();
            for (Map.Entry<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> pathCollectionEntry : changes.entrySet()) {
                for (ResourceChange change : pathCollectionEntry.getValue()) {
                    ResourceChangeType type = change.getType();
                    Path resource = Paths.convert((org.uberfire.backend.vfs.Path)pathCollectionEntry.getKey());
                    PortablePreconditions.checkNotNull((String)"type", (Object)type);
                    PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
                    String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
                    changedFilesKieBuilderPaths.add(destinationPath);
                    switch (type) {
                        case ADD: 
                        case UPDATE: {
                            if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) break;
                            this.update(nonKieResourceValidatorAddedMessages, nonKieResourceValidatorRemovedMessages, resource, destinationPath);
                            break;
                        }
                        case DELETE: {
                            this.delete(nonKieResourceValidatorRemovedMessages, resource, destinationPath);
                        }
                    }
                }
            }
            IncrementalBuildResults results = new IncrementalBuildResults(this.projectGAV);
            this.buildIncrementally(results, this.toArray(changedFilesKieBuilderPaths));
            results.addAllAddedMessages(MessageConverter.convertValidationMessages(nonKieResourceValidatorAddedMessages));
            results.addAllRemovedMessages(MessageConverter.convertValidationMessages(nonKieResourceValidatorRemovedMessages));
            return results;
        }
    }

    private String[] toArray(List<String> stringList) {
        String[] stringArray = new String[stringList.size()];
        stringList.toArray(stringArray);
        return stringArray;
    }

    private void delete(List<ValidationMessage> nonKieResourceValidatorRemovedMessages, Path resource, String destinationPath) {
        this.nonKieResourceValidationHelpers.remove(resource);
        List<ValidationMessage> removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource);
        if (removedValidationMessages != null && !removedValidationMessages.isEmpty()) {
            for (ValidationMessage validationMessage : removedValidationMessages) {
                nonKieResourceValidatorRemovedMessages.add(validationMessage);
            }
        }
        this.kieFileSystem.delete(new String[]{destinationPath});
        this.removeJavaClass(resource);
    }

    private void update(List<ValidationMessage> nonKieResourceValidatorAddedMessages, List<ValidationMessage> nonKieResourceValidatorRemovedMessages, Path resource, String destinationPath) {
        BuildValidationHelper validator = this.getBuildValidationHelper(resource);
        if (validator != null) {
            List<ValidationMessage> removedValidationMessages;
            List addedValidationMessages = validator.validate(Paths.convert((Path)resource));
            if (addedValidationMessages != null && !addedValidationMessages.isEmpty()) {
                for (ValidationMessage validationMessage : addedValidationMessages) {
                    nonKieResourceValidatorAddedMessages.add(validationMessage);
                }
            }
            if ((removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource)) != null && !removedValidationMessages.isEmpty()) {
                for (ValidationMessage validationMessage : removedValidationMessages) {
                    nonKieResourceValidatorRemovedMessages.add(validationMessage);
                }
            }
            this.nonKieResourceValidationHelpers.put(resource, validator);
            this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
        }
        InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
        BufferedInputStream bis = new BufferedInputStream(is);
        this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
        this.addJavaClass(resource);
        this.handles.put(BaseFileNameResolver.getBaseFileName(destinationPath), Paths.convert((Path)resource));
    }

    private void buildIncrementally(IncrementalBuildResults results, String ... destinationPath) {
        try {
            IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(destinationPath).build();
            results.addAllAddedMessages(MessageConverter.convertMessages(incrementalResults.getAddedMessages(), this.handles));
            results.addAllRemovedMessages(MessageConverter.convertMessages(incrementalResults.getRemovedMessages(), this.handles));
            for (Message message : incrementalResults.getRemovedMessages()) {
                this.handles.remove("src/main/resources/" + BaseFileNameResolver.getBaseFileName(message.getPath()));
            }
        }
        catch (LinkageError e) {
            String msg = MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage());
            logger.warn(msg);
            results.addAddedMessage(BuildMessageBuilder.makeWarningMessage(msg));
        }
        catch (Throwable e) {
            String msg = e.getLocalizedMessage();
            logger.error(msg, e);
            results.addAddedMessage(BuildMessageBuilder.makeErrorMessage(msg));
        }
    }

    private void checkAFullBuildHasBeenPerformed() {
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KieModule getKieModule() {
        if (!this.isBuilt()) {
            this.build();
        }
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            return this.kieBuilder.getKieModule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KieModule getKieModuleIgnoringErrors() {
        if (!this.isBuilt()) {
            this.build();
        }
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            return ((InternalKieBuilder)this.kieBuilder).getKieModuleIgnoringErrors();
        }
    }

    public KieContainer getKieContainer() {
        BuildResults results = null;
        if (!this.isBuilt()) {
            results = this.build();
        } else {
            results = new BuildResults();
            results.addAllBuildMessages(MessageConverter.convertMessages(this.kieBuilder.getResults().getMessages(), this.handles));
        }
        if (results.getErrorMessages().isEmpty()) {
            KieModule kieModule = this.kieBuilder.getKieModule();
            ReleaseId releaseId = kieModule.getReleaseId();
            KieContainer kieContainer = this.kieServices.newKieContainer(releaseId);
            return kieContainer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBuilt() {
        KieFileSystem kieFileSystem = this.kieFileSystem;
        synchronized (kieFileSystem) {
            return this.kieBuilder != null;
        }
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            if (this.dotFileFilter.accept((Object)path)) continue;
            BuildValidationHelper validator = this.getBuildValidationHelper(path);
            if (validator != null) {
                this.nonKieResourceValidationHelpers.put(path, validator);
            }
            String destinationPath = path.toUri().toString().substring(this.projectPrefix.length() + 1);
            InputStream is = this.ioService.newInputStream(path, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
            this.handles.put(BaseFileNameResolver.getBaseFileName(destinationPath), Paths.convert((Path)path));
            this.addJavaClass(path);
        }
    }

    private void addJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.add(fullyQualifiedClassName);
        }
    }

    private void removeJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.remove(fullyQualifiedClassName);
        }
    }

    private String getFullyQualifiedClassName(Path path) {
        Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
        String packageName = pkg.getPackageName();
        if (packageName == null) {
            return null;
        }
        String className = path.getFileName().toString().replace(".java", "");
        return packageName.equals("") ? className : packageName + "." + className;
    }

    public TypeSource getClassSource(KieModuleMetaData metaData, Class<?> clazz) {
        if (metaData.getTypeMetaInfo(clazz).isDeclaredType()) {
            return TypeSource.DECLARED;
        }
        String fullyQualifiedClassName = clazz.getName();
        int innerClassIdentifierIndex = fullyQualifiedClassName.indexOf("$");
        if (innerClassIdentifierIndex > 0) {
            fullyQualifiedClassName = fullyQualifiedClassName.substring(0, innerClassIdentifierIndex);
        }
        if (this.javaResources.contains(fullyQualifiedClassName)) {
            return TypeSource.JAVA_PROJECT;
        }
        return TypeSource.JAVA_DEPENDENCY;
    }

    private BuildValidationHelper getBuildValidationHelper(Path nioResource) {
        for (BuildValidationHelper validator : this.buildValidationHelpers) {
            org.uberfire.backend.vfs.Path resource;
            if (!validator.accepts(resource = Paths.convert((Path)nioResource))) continue;
            return validator;
        }
        return null;
    }
}

